/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.DeterminismEvaluator;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.tree.QualifiedName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageProcessorCompiler {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final ExpressionCompiler compiler = this.functionResolution.getExpressionCompiler();

    @Test
    public void testNoCaching() {
        ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ResolvedFunction resolvedFunction = this.functionResolution.resolveFunction(QualifiedName.of((String)"concat"), TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, arrayType}));
        projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
        ImmutableList projections = projectionsBuilder.build();
        PageProcessor pageProcessor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
        PageProcessor pageProcessor2 = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
        Assert.assertTrue((pageProcessor != pageProcessor2 ? 1 : 0) != 0);
    }

    @Test
    public void testSanityRLE() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.field((int)1, (Type)VarcharType.VARCHAR)), 8192).get();
        Slice varcharValue = Slices.utf8Slice((String)"hello");
        Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)123L, (int)100), RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)varcharValue, (int)100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        Assert.assertTrue((boolean)(outputPage.getBlock(1) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rleBlock.getValue(), 0), (long)123L);
        RunLengthEncodedBlock rleBlock1 = (RunLengthEncodedBlock)outputPage.getBlock(1);
        Assert.assertEquals((Object)VarcharType.VARCHAR.getSlice(rleBlock1.getValue(), 0), (Object)varcharValue);
    }

    @Test
    public void testSanityFilterOnDictionary() {
        CallExpression lengthVarchar = new CallExpression(this.functionResolution.resolveFunction(QualifiedName.of((String)"length"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)));
        ResolvedFunction lessThan = this.functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression filter = new CallExpression(lessThan, (List)ImmutableList.of((Object)lengthVarchar, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
        Page outputPage2 = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage2.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage2.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock2 = (DictionaryBlock)outputPage2.getBlock(0);
        Assert.assertEquals((Object)dictionaryBlock2.getDictionary(), (Object)dictionaryBlock.getDictionary());
    }

    @Test
    public void testSanityFilterOnRLE() {
        ResolvedFunction lessThan = this.functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression filter = new CallExpression(lessThan, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT)), 8192).get();
        Page page = new Page(new Block[]{BlockAssertions.createRepeatedValuesBlock(5L, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof RunLengthEncodedBlock));
        RunLengthEncodedBlock rle = (RunLengthEncodedBlock)outputPage.getBlock(0);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(rle.getValue(), 0), (long)5L);
    }

    @Test
    public void testSanityColumnarDictionary() {
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR)), 8192).get();
        Page page = new Page(new Block[]{TestPageProcessorCompiler.createDictionaryBlock(TestPageProcessorCompiler.createExpectedValues(10), 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)100);
        Assert.assertTrue((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
        DictionaryBlock dictionaryBlock = (DictionaryBlock)outputPage.getBlock(0);
        Assert.assertEquals((int)dictionaryBlock.getDictionary().getPositionCount(), (int)10);
    }

    @Test
    public void testNonDeterministicProject() {
        ResolvedFunction lessThan = this.functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression random = new CallExpression(this.functionResolution.resolveFunction(QualifiedName.of((String)"random"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (List)ImmutableList.of((Object)col0, (Object)random));
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)lessThanRandomExpression), 8192).get();
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
        Page page = new Page(new Block[]{BlockAssertions.createLongDictionaryBlock(1, 100)});
        Page outputPage = (Page)((Optional)Iterators.getOnlyElement((Iterator)processor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), page))).orElseThrow(() -> new AssertionError((Object)"page is not present"));
        Assert.assertFalse((boolean)(outputPage.getBlock(0) instanceof DictionaryBlock));
    }

    private static Block createDictionaryBlock(Slice[] expectedValues, int positionCount) {
        int dictionarySize = expectedValues.length;
        int[] ids = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            ids[i] = i % dictionarySize;
        }
        return DictionaryBlock.create((int)ids.length, (Block)BlockAssertions.createSlicesBlock(expectedValues), (int[])ids);
    }

    private static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestPageProcessorCompiler.createExpectedValue(position);
        }
        return expectedValues;
    }

    private static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }
}

