/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.type.UnknownType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestZipFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSameLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1, 2]", "ARRAY['a', 'b']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1, 2]", "ARRAY['a', VARCHAR 'b']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.VARCHAR})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1, 2, 3, 4]", "ARRAY['a', 'b', 'c', 'd']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(2, "b"), TestZipFunction.list(3, "c"), TestZipFunction.list(4, "d")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1, 2]", "ARRAY['a', 'b']", " ARRAY['c', 'd']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a", "c"), TestZipFunction.list(2, "b", "d")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1, 2]", "ARRAY['a', 'b']", "ARRAY['c', 'd']", "ARRAY['e', 'f']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1), VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a", "c", "e"), TestZipFunction.list(2, "b", "d", "f")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[]", "ARRAY[]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN})).isEqualTo(TestZipFunction.list(new Object[0]));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[]", "ARRAY[]", "ARRAY[]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN})).isEqualTo(TestZipFunction.list(new Object[0]));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[]", "ARRAY[]", "ARRAY[]", "ARRAY[]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN})).isEqualTo(TestZipFunction.list(new Object[0]));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[NULL]", "ARRAY[NULL]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN})).isEqualTo(TestZipFunction.list(TestZipFunction.list(null, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[ARRAY[1, 1], ARRAY[1, 2]]", "ARRAY[ARRAY[2, 1], ARRAY[2, 2]]")))).hasType(TestZipFunction.zipReturnType(new Type[]{new ArrayType((Type)IntegerType.INTEGER), new ArrayType((Type)IntegerType.INTEGER)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(TestZipFunction.list(1, 1), TestZipFunction.list(2, 1)), TestZipFunction.list(TestZipFunction.list(1, 2), TestZipFunction.list(2, 2))));
    }

    @Test
    public void testDifferentLength() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[1]", "ARRAY['a', 'b']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(1, "a"), TestZipFunction.list(null, "b")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[NULL, 2]", "ARRAY['a']")))).hasType(TestZipFunction.zipReturnType(new Type[]{IntegerType.INTEGER, VarcharType.createVarcharType((int)1)})).isEqualTo(TestZipFunction.list(TestZipFunction.list(null, "a"), TestZipFunction.list(2, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[]", "ARRAY[1]", "ARRAY[1, 2]", "ARRAY[1, 2, 3]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, IntegerType.INTEGER, IntegerType.INTEGER, IntegerType.INTEGER})).isEqualTo(TestZipFunction.list(TestZipFunction.list(null, 1, 1, 1), TestZipFunction.list(null, null, 2, 2), TestZipFunction.list(null, null, null, 3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "ARRAY[]", "ARRAY[NULL]", "ARRAY[NULL, NULL]")))).hasType(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, UnknownType.UNKNOWN})).isEqualTo(TestZipFunction.list(TestZipFunction.list(null, null, null), TestZipFunction.list(null, null, null)));
    }

    @Test
    public void testWithNull() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", "CAST(NULL AS ARRAY(UNKNOWN))", "ARRAY[]", "ARRAY[1]")))).isNull(TestZipFunction.zipReturnType(new Type[]{UnknownType.UNKNOWN, UnknownType.UNKNOWN, IntegerType.INTEGER}));
    }

    @Test
    public void testAllArities() {
        for (int arity = 2; arity <= 5; ++arity) {
            List<String> arguments = IntStream.rangeClosed(1, arity).mapToObj(index -> "ARRAY[" + index + "]").collect(Collectors.toList());
            Type[] types = (Type[])IntStream.rangeClosed(1, arity).mapToObj(index -> IntegerType.INTEGER).toArray(Type[]::new);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("zip", arguments)))).hasType(TestZipFunction.zipReturnType(types)).isEqualTo(TestZipFunction.list(IntStream.rangeClosed(1, arity).boxed().collect(Collectors.toList())));
        }
    }

    private static Type zipReturnType(Type ... types) {
        return new ArrayType((Type)RowType.anonymous(TestZipFunction.list(types)));
    }

    @SafeVarargs
    private static <T> List<T> list(T ... a) {
        return Arrays.asList(a);
    }
}

