/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.Session;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.query.QueryAssertions;
import java.time.Instant;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCurrentTimestamp {
    @Test
    public void testRoundUp() {
        try (QueryAssertions assertions = new QueryAssertions();){
            Session session = Session.builder((Session)assertions.getDefaultSession()).setTimeZoneKey(TimeZoneKey.UTC_KEY).setStart(Instant.ofEpochSecond(0L, 999999999L)).build();
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.0 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.00 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.0000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.00000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.0000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '1970-01-01 00:00:01.00000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.999999999 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.9999999990 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.99999999900 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.999999999000 UTC'");
        }
    }

    @Test
    public void testRoundDown() {
        try (QueryAssertions assertions = new QueryAssertions();){
            Session session = Session.builder((Session)assertions.getDefaultSession()).setTimeZoneKey(TimeZoneKey.UTC_KEY).setStart(Instant.ofEpochSecond(0L, 1L)).build();
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.0 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.00 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.0000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.00000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.0000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.00000000 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.000000001 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.0000000010 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.00000000100 UTC'");
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '1970-01-01 00:00:00.000000001000 UTC'");
        }
    }
}

