/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TempFile;
import io.trino.security.GroupProviderManager;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.GroupProviderFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupProviderManager {
    private static final GroupProvider TEST_GROUP_PROVIDER = user -> ImmutableSet.of((Object)"test", (Object)user);
    private static final GroupProviderFactory TEST_GROUP_PROVIDER_FACTORY = new GroupProviderFactory(){

        public String getName() {
            return "testGroupProvider";
        }

        public GroupProvider create(Map<String, String> config) {
            return TEST_GROUP_PROVIDER;
        }
    };

    @Test
    public void testGroupProviderIsLoaded() throws IOException {
        try (TempFile tempFile = new TempFile();){
            Files.write(tempFile.path(), "group-provider.name=testGroupProvider".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            GroupProviderManager groupProviderManager = new GroupProviderManager();
            groupProviderManager.addGroupProviderFactory(TEST_GROUP_PROVIDER_FACTORY);
            groupProviderManager.loadConfiguredGroupProvider(tempFile.file());
            Assert.assertEquals((Set)groupProviderManager.getGroups("alice"), (Set)ImmutableSet.of((Object)"test", (Object)"alice"));
            Assert.assertEquals((Set)groupProviderManager.getGroups("bob"), (Set)ImmutableSet.of((Object)"test", (Object)"bob"));
        }
    }
}

