/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.metadata.MetadataManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestWindowFrameRange
extends BasePlanTest {
    @Test
    public void testFramePrecedingWithSortKeyCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE x PRECEDING) FROM (VALUES (1, 1.1), (2, 2.2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})), PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.PRECEDING, Optional.of("frame_start_value"), Optional.of("key_for_frame_start_comparison"), FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty())), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_comparison", (Object)PlanMatchPattern.expression("CAST(key AS decimal(12, 1))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("key_for_frame_start_calculation"), (Object)new SymbolReference("x"))))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_start_calculation", (Object)PlanMatchPattern.expression("CAST(key AS decimal(10, 0))")), PlanMatchPattern.filter("IF((x >= CAST(0 AS DECIMAL(2,1))), true, " + String.format("CAST(fail(INTEGER '%d', VARCHAR 'Window frame offset value must not be negative or null') AS boolean))", StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new DecimalLiteral("1.1")), (Object)ImmutableList.of((Object)new LongLiteral("2"), (Object)new DecimalLiteral("2.2")))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFrameFollowingWithOffsetCoercion() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN CURRENT ROW AND x FOLLOWING) FROM (VALUES (1.1, 1), (2.2, 2)) t(key, x)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)2, (int)1)})), PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.FOLLOWING, Optional.of("frame_end_value"), Optional.of("key_for_frame_end_comparison"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"key_for_frame_end_comparison", (Object)PlanMatchPattern.expression("CAST(key AS decimal(12, 1))")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("offset"))))), PlanMatchPattern.filter("IF((offset >= CAST(0 AS DECIMAL(10, 0))), true, " + String.format("CAST(fail(INTEGER '%d', VARCHAR 'Window frame offset value must not be negative or null') AS boolean))", StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"offset", (Object)PlanMatchPattern.expression("CAST(x AS decimal(10, 0))")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new DecimalLiteral("1.1"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new DecimalLiteral("2.2"), (Object)new LongLiteral("2")))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }

    @Test
    public void testFramePrecedingFollowingNoCoercions() {
        String sql = "SELECT array_agg(key) OVER(ORDER BY key RANGE BETWEEN x PRECEDING AND y FOLLOWING) FROM (VALUES (1, 1, 1), (2, 2, 2)) t(key, x, y)";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"key"), (Map<String, SortOrder>)ImmutableMap.of((Object)"key", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("array_agg_result", PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"key")), MetadataManager.createTestMetadataManager().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})), PlanMatchPattern.windowFrame(WindowFrame.Type.RANGE, FrameBound.Type.PRECEDING, Optional.of("frame_start_value"), Optional.of("key"), FrameBound.Type.FOLLOWING, Optional.of("frame_end_value"), Optional.of("key"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_end_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$add"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("y"))))), PlanMatchPattern.filter("IF((y >= CAST(0 AS INTEGER)), true, " + String.format("CAST(fail(INTEGER '%d', VARCHAR 'Window frame offset value must not be negative or null') AS boolean))", StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"frame_start_value", (Object)PlanMatchPattern.expression((Expression)new FunctionCall(QualifiedName.of((String)"$operator$subtract"), (List)ImmutableList.of((Object)new SymbolReference("key"), (Object)new SymbolReference("x"))))), PlanMatchPattern.filter("IF((x >= CAST(0 AS INTEGER)), true, " + String.format("CAST(fail(INTEGER '%d', VARCHAR 'Window frame offset value must not be negative or null') AS boolean))", StandardErrorCode.INVALID_WINDOW_FRAME.toErrorCode().getCode()), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"key", (Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("1"), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new LongLiteral("2"), (Object)new LongLiteral("2"), (Object)new LongLiteral("2")))))))))));
        this.assertPlan(sql, LogicalPlanner.Stage.CREATED, pattern);
    }
}

