/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import java.util.function.Predicate;

public class PredicateMatcher<T extends PlanNode>
implements Matcher {
    private final Predicate<T> predicate;

    public PredicateMatcher(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return this.predicate.test(node);
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return MatchResult.match();
    }

    public String toString() {
        return "(predicated)";
    }
}

