/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BaseStrictSymbolsMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class StrictAssignedSymbolsMatcher
extends BaseStrictSymbolsMatcher {
    private final Collection<? extends RvalueMatcher> getExpected;

    public StrictAssignedSymbolsMatcher(Function<PlanNode, Set<Symbol>> getActual, Collection<? extends RvalueMatcher> getExpected) {
        super(getActual);
        this.getExpected = Objects.requireNonNull(getExpected, "getExpected is null");
    }

    @Override
    protected Set<Symbol> getExpectedSymbols(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        ImmutableSet.Builder expected = ImmutableSet.builder();
        for (RvalueMatcher rvalueMatcher : this.getExpected) {
            Optional<Symbol> assigned = rvalueMatcher.getAssignedSymbol(node, session, metadata, symbolAliases);
            if (assigned.isEmpty()) {
                return null;
            }
            expected.add((Object)assigned.get());
        }
        return expected.build();
    }

    public static Function<PlanNode, Set<Symbol>> actualAssignments() {
        return node -> ((ProjectNode)node).getAssignments().getSymbols();
    }

    public static Function<PlanNode, Set<Symbol>> actualSubqueryAssignments() {
        return node -> ((ApplyNode)node).getSubqueryAssignments().getSymbols();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exact assignments", this.getExpected).toString();
    }
}

