/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.DescriptorArgument;
import io.trino.spi.ptf.ScalarArgument;
import io.trino.spi.ptf.TableArgument;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.tree.SymbolReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableFunctionMatcher
implements Matcher {
    private final String name;
    private final Map<String, ArgumentValue> arguments;
    private final List<String> properOutputs;
    private final List<List<String>> copartitioningLists;

    private TableFunctionMatcher(String name, Map<String, ArgumentValue> arguments, List<String> properOutputs, List<List<String>> copartitioningLists) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = ImmutableMap.copyOf(Objects.requireNonNull(arguments, "arguments is null"));
        this.properOutputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(properOutputs, "properOutputs is null"));
        Objects.requireNonNull(copartitioningLists, "copartitioningLists is null");
        this.copartitioningLists = (List)copartitioningLists.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableFunctionNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableFunctionNode tableFunctionNode = (TableFunctionNode)node;
        if (!this.name.equals(tableFunctionNode.getName())) {
            return MatchResult.NO_MATCH;
        }
        if (this.arguments.size() != tableFunctionNode.getArguments().size()) {
            return MatchResult.NO_MATCH;
        }
        for (Map.Entry<String, ArgumentValue> entry : this.arguments.entrySet()) {
            Set actualPassThrough;
            String name = entry.getKey();
            Argument actual = (Argument)tableFunctionNode.getArguments().get(name);
            if (actual == null) {
                return MatchResult.NO_MATCH;
            }
            ArgumentValue expected = entry.getValue();
            if (expected instanceof DescriptorArgumentValue) {
                DescriptorArgumentValue expectedDescriptor = (DescriptorArgumentValue)expected;
                if (actual instanceof DescriptorArgument) {
                    DescriptorArgument actualDescriptor = (DescriptorArgument)actual;
                    if (expectedDescriptor.descriptor().equals(actualDescriptor.getDescriptor())) continue;
                }
                return MatchResult.NO_MATCH;
            }
            if (expected instanceof ScalarArgumentValue) {
                ScalarArgumentValue expectedScalar = (ScalarArgumentValue)expected;
                if (actual instanceof ScalarArgument) {
                    ScalarArgument actualScalar = (ScalarArgument)actual;
                    if (Objects.equals(expectedScalar.value(), actualScalar.getValue())) continue;
                }
                return MatchResult.NO_MATCH;
            }
            if (!(actual instanceof TableArgument)) {
                return MatchResult.NO_MATCH;
            }
            TableArgumentValue expectedTableArgument = (TableArgumentValue)expected;
            TableFunctionNode.TableArgumentProperties argumentProperties = (TableFunctionNode.TableArgumentProperties)tableFunctionNode.getTableArgumentProperties().get(expectedTableArgument.sourceIndex());
            if (!name.equals(argumentProperties.getArgumentName())) {
                return MatchResult.NO_MATCH;
            }
            if (expectedTableArgument.rowSemantics() != argumentProperties.isRowSemantics() || expectedTableArgument.pruneWhenEmpty() != argumentProperties.isPruneWhenEmpty() || expectedTableArgument.passThroughColumns() != argumentProperties.getPassThroughSpecification().declaredAsPassThrough()) {
                return MatchResult.NO_MATCH;
            }
            boolean specificationMatches = expectedTableArgument.specification().map(specification -> (DataOrganizationSpecification)specification.getExpectedValue(symbolAliases)).equals(argumentProperties.getSpecification());
            if (!specificationMatches) {
                return MatchResult.NO_MATCH;
            }
            Set expectedPassThrough = (Set)expectedTableArgument.passThroughSymbols().stream().map(symbolAliases::get).collect(ImmutableSet.toImmutableSet());
            if (expectedPassThrough.equals(actualPassThrough = (Set)argumentProperties.getPassThroughSpecification().columns().stream().map(TableFunctionNode.PassThroughColumn::symbol).map(Symbol::toSymbolReference).collect(ImmutableSet.toImmutableSet()))) continue;
            return MatchResult.NO_MATCH;
        }
        if (this.properOutputs.size() != tableFunctionNode.getProperOutputs().size()) {
            return MatchResult.NO_MATCH;
        }
        if (!ImmutableSet.copyOf(this.copartitioningLists).equals((Object)ImmutableSet.copyOf((Collection)tableFunctionNode.getCopartitioningLists()))) {
            return MatchResult.NO_MATCH;
        }
        ImmutableMap.Builder properOutputsMapping = ImmutableMap.builder();
        for (int i = 0; i < this.properOutputs.size(); ++i) {
            properOutputsMapping.put((Object)this.properOutputs.get(i), (Object)((Symbol)tableFunctionNode.getProperOutputs().get(i)).toSymbolReference());
        }
        return MatchResult.match(SymbolAliases.builder().putAll(symbolAliases).putAll((Map<String, SymbolReference>)properOutputsMapping.buildOrThrow()).build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("arguments", this.arguments).add("properOutputs", this.properOutputs).add("copartitioningLists", this.copartitioningLists).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ArgumentValue {
    }

    public record DescriptorArgumentValue(Optional<Descriptor> descriptor) implements ArgumentValue
    {
        public DescriptorArgumentValue(Optional<Descriptor> descriptor) {
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        public static DescriptorArgumentValue descriptorArgument(Descriptor descriptor) {
            return new DescriptorArgumentValue(Optional.of(Objects.requireNonNull(descriptor, "descriptor is null")));
        }

        public static DescriptorArgumentValue nullDescriptor() {
            return new DescriptorArgumentValue(Optional.empty());
        }
    }

    public record ScalarArgumentValue(Object value) implements ArgumentValue
    {
    }

    public record TableArgumentValue(int sourceIndex, boolean rowSemantics, boolean pruneWhenEmpty, boolean passThroughColumns, Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification, Set<String> passThroughSymbols) implements ArgumentValue
    {
        public TableArgumentValue(int sourceIndex, boolean rowSemantics, boolean pruneWhenEmpty, boolean passThroughColumns, Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification, Set<String> passThroughSymbols) {
            this.sourceIndex = sourceIndex;
            this.rowSemantics = rowSemantics;
            this.pruneWhenEmpty = pruneWhenEmpty;
            this.passThroughColumns = passThroughColumns;
            this.specification = Objects.requireNonNull(specification, "specification is null");
            this.passThroughSymbols = ImmutableSet.copyOf(passThroughSymbols);
        }

        public static class Builder {
            private final int sourceIndex;
            private boolean rowSemantics;
            private boolean pruneWhenEmpty;
            private boolean passThroughColumns;
            private Optional<ExpectedValueProvider<DataOrganizationSpecification>> specification = Optional.empty();
            private Set<String> passThroughSymbols = ImmutableSet.of();

            private Builder(int sourceIndex) {
                this.sourceIndex = sourceIndex;
            }

            public static Builder tableArgument(int sourceIndex) {
                return new Builder(sourceIndex);
            }

            public Builder rowSemantics() {
                this.rowSemantics = true;
                this.pruneWhenEmpty = true;
                return this;
            }

            public Builder pruneWhenEmpty() {
                this.pruneWhenEmpty = true;
                return this;
            }

            public Builder passThroughColumns() {
                this.passThroughColumns = true;
                return this;
            }

            public Builder specification(ExpectedValueProvider<DataOrganizationSpecification> specification) {
                this.specification = Optional.of(specification);
                return this;
            }

            public Builder passThroughSymbols(Set<String> symbols) {
                this.passThroughSymbols = symbols;
                return this;
            }

            private TableArgumentValue build() {
                return new TableArgumentValue(this.sourceIndex, this.rowSemantics, this.pruneWhenEmpty, this.passThroughColumns, this.specification, this.passThroughSymbols);
            }
        }
    }

    public static class Builder {
        private final PlanMatchPattern[] sources;
        private String name;
        private final ImmutableMap.Builder<String, ArgumentValue> arguments = ImmutableMap.builder();
        private List<String> properOutputs = ImmutableList.of();
        private final ImmutableList.Builder<List<String>> copartitioningLists = ImmutableList.builder();

        Builder(PlanMatchPattern ... sources) {
            this.sources = Arrays.copyOf(sources, sources.length);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addDescriptorArgument(String name, DescriptorArgumentValue descriptor) {
            this.arguments.put((Object)name, (Object)descriptor);
            return this;
        }

        public Builder addScalarArgument(String name, Object value) {
            this.arguments.put((Object)name, (Object)new ScalarArgumentValue(value));
            return this;
        }

        public Builder addTableArgument(String name, TableArgumentValue.Builder tableArgument) {
            this.arguments.put((Object)name, (Object)tableArgument.build());
            return this;
        }

        public Builder properOutputs(List<String> properOutputs) {
            this.properOutputs = properOutputs;
            return this;
        }

        public Builder addCopartitioning(List<String> copartitioning) {
            this.copartitioningLists.add(copartitioning);
            return this;
        }

        public PlanMatchPattern build() {
            return PlanMatchPattern.node(TableFunctionNode.class, this.sources).with(new TableFunctionMatcher(this.name, (Map<String, ArgumentValue>)this.arguments.buildOrThrow(), this.properOutputs, (List<List<String>>)this.copartitioningLists.build()));
        }
    }
}

