/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WindowFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;
    private final Optional<ResolvedFunction> resolvedFunction;
    private final Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker;

    public WindowFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker, Optional<ResolvedFunction> resolvedFunction, Optional<ExpectedValueProvider<WindowNode.Frame>> frameMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "callMaker is null");
        this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
        this.frameMaker = Objects.requireNonNull(frameMaker, "frameMaker is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Map assignments;
        Optional<Symbol> result = Optional.empty();
        if (node instanceof WindowNode) {
            assignments = ((WindowNode)node).getWindowFunctions();
        } else if (node instanceof PatternRecognitionNode) {
            assignments = ((PatternRecognitionNode)node).getWindowFunctions();
        } else {
            return result;
        }
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        Optional<WindowNode.Frame> expectedFrame = this.frameMaker.map(maker -> (WindowNode.Frame)maker.getExpectedValue(symbolAliases));
        for (Map.Entry assignment : assignments.entrySet()) {
            WindowNode.Function function = (WindowNode.Function)assignment.getValue();
            boolean signatureMatches = this.resolvedFunction.map(arg_0 -> ((ResolvedFunction)((WindowNode.Function)assignment.getValue()).getResolvedFunction()).equals(arg_0)).orElse(true);
            if (!signatureMatches || !this.windowFunctionMatches(function, expectedCall, expectedFrame)) continue;
            Preconditions.checkState((boolean)result.isEmpty(), (String)"Ambiguous function calls in %s", (Object)node);
            result = Optional.of((Symbol)assignment.getKey());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean windowFunctionMatches(WindowNode.Function windowFunction, FunctionCall expectedCall, Optional<WindowNode.Frame> expectedFrame) {
        if (expectedCall.getWindow().isPresent()) {
            return false;
        }
        if (this.resolvedFunction.map(arg_0 -> ((ResolvedFunction)windowFunction.getResolvedFunction()).equals(arg_0)).orElse(true) == false) return false;
        if (expectedFrame.map(arg_0 -> ((WindowNode.Frame)windowFunction.getFrame()).equals(arg_0)).orElse(true) == false) return false;
        if (!Objects.equals(ResolvedFunction.extractFunctionName((QualifiedName)expectedCall.getName()), windowFunction.getResolvedFunction().getSignature().getName())) return false;
        if (!Objects.equals(expectedCall.getArguments(), windowFunction.getArguments())) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("callMaker", this.callMaker).add("signature", this.resolvedFunction.orElse(null)).add("frameMaker", this.frameMaker.orElse(null)).toString();
    }
}

