/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestInlineProjections
extends BaseRuleTest {
    private static final RowType MSG_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("y"), (Type)VarcharType.VARCHAR)));

    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("identity"), PlanBuilder.expression("symbol")).put(p.symbol("multi_complex_1"), PlanBuilder.expression("complex + 1")).put(p.symbol("multi_complex_2"), PlanBuilder.expression("complex + 2")).put(p.symbol("multi_literal_1"), PlanBuilder.expression("literal + 1")).put(p.symbol("multi_literal_2"), PlanBuilder.expression("literal + 2")).put(p.symbol("single_complex"), PlanBuilder.expression("complex_2 + 2")).put(p.symbol("try"), PlanBuilder.expression("try(complex / literal)")).put(p.symbol("msg_xx"), PlanBuilder.expression("z + 1")).put(p.symbol("try_symbol_reference"), PlanBuilder.expression("try(2 * v)")).put(p.symbol("multi_symbol_reference"), PlanBuilder.expression("v + v")).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("symbol"), PlanBuilder.expression("x")).put(p.symbol("complex"), PlanBuilder.expression("x * 2")).put(p.symbol("literal"), PlanBuilder.expression("1")).put(p.symbol("complex_2"), PlanBuilder.expression("x - 1")).put(p.symbol("z"), PlanBuilder.expression("msg[1]")).put(p.symbol("v"), PlanBuilder.expression("x")).build(), (PlanNode)p.values(p.symbol("x"), p.symbol("msg", (Type)MSG_TYPE))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression("x")).put((Object)"out2", (Object)PlanMatchPattern.expression("y + 1")).put((Object)"out3", (Object)PlanMatchPattern.expression("y + 2")).put((Object)"out4", (Object)PlanMatchPattern.expression("1 + 1")).put((Object)"out5", (Object)PlanMatchPattern.expression("1 + 2")).put((Object)"out6", (Object)PlanMatchPattern.expression("x - 1 + 2")).put((Object)"out7", (Object)PlanMatchPattern.expression("try(y / 1)")).put((Object)"out8", (Object)PlanMatchPattern.expression("z + 1")).put((Object)"out9", (Object)PlanMatchPattern.expression("try(2 * x)")).put((Object)"out10", (Object)PlanMatchPattern.expression("x + x")).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x"), (Object)"y", (Object)PlanMatchPattern.expression("x * 2"), (Object)"z", (Object)PlanMatchPattern.expression("msg[1]")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"msg", (Object)1)))));
    }

    @Test
    public void testInlineEffectivelyLiteral() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("decimal_multiplication"), PlanBuilder.expression("decimal_literal * decimal_literal")).put(p.symbol("decimal_addition"), PlanBuilder.expression("decimal_literal + decimal_literal")).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("decimal_literal", (Type)DecimalType.createDecimalType((int)8, (int)4)), PlanBuilder.expression("CAST(DECIMAL '12.5' AS decimal(8,4))")).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project(Map.of("decimal_multiplication", PlanMatchPattern.expression("CAST(DECIMAL '12.5' AS decimal(8, 4)) * CAST(DECIMAL '12.5' AS decimal(8, 4))"), "decimal_addition", PlanMatchPattern.expression("CAST(DECIMAL '12.5' AS decimal(8, 4)) + CAST(DECIMAL '12.5' AS decimal(8, 4))")), PlanMatchPattern.values(Map.of("x", 0))));
    }

    @Test
    public void testEliminatesIdentityProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.builder().put(p.symbol("single_complex"), PlanBuilder.expression("complex + 2")).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex"), PlanBuilder.expression("x - 1")).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"out1", (Object)PlanMatchPattern.expression("x - 1 + 2")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0))));
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)PlanBuilder.expression("value")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x"), p.symbol("y")}), (PlanNode)p.values(p.symbol("x"), p.symbol("y"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("x")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)1))));
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
        this.tester().assertThat((Rule<?>)new InlineProjections(this.tester().getPlannerContext(), this.tester().getTypeAnalyzer())).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value_1")}), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("value_1"), (Expression)PlanBuilder.expression("value - 1")), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
    }
}

