/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeExcept;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeExcept
extends BaseRuleTest {
    public TestMergeExcept() {
        super(new Plugin[0]);
    }

    @Test
    public void testFlattening() {
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            ExceptNode u1 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)c, (Object)a).put((Object)c, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            ExceptNode u2 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)u1, (Object)u2));
        }).matches(PlanMatchPattern.except(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"), PlanMatchPattern.except(PlanMatchPattern.values("a"), PlanMatchPattern.values("b"))));
    }

    @Test
    public void testNotFlattening() {
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            ExceptNode u2 = p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)d, (Object)a).put((Object)d, (Object)b).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, a), (Object)p.values(1, b)));
            return p.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)e, (Object)c).put((Object)e, (Object)d).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, c), (Object)u2));
        }).doesNotFire();
    }

    @Test
    public void testQuantifiers() {
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> this.buildNestedExcept((PlanBuilder)p, true, true)).matches(PlanMatchPattern.except(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("b")));
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> this.buildNestedExcept((PlanBuilder)p, true, false)).matches(PlanMatchPattern.except(true, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("b")));
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> this.buildNestedExcept((PlanBuilder)p, false, true)).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergeExcept()).on(p -> this.buildNestedExcept((PlanBuilder)p, false, false)).matches(PlanMatchPattern.except(false, PlanMatchPattern.values("v_1"), PlanMatchPattern.values("v_2"), PlanMatchPattern.values("b")));
    }

    private PlanNode buildNestedExcept(PlanBuilder builder, boolean sourceDistinct, boolean parentDistinct) {
        Symbol v1 = builder.symbol("v_1");
        Symbol v2 = builder.symbol("v_2");
        Symbol a = builder.symbol("a");
        Symbol b = builder.symbol("b");
        Symbol c = builder.symbol("c");
        ExceptNode child1 = builder.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)a, (Object)v1, (Object)a, (Object)v2), (List<PlanNode>)ImmutableList.of((Object)builder.values(v1), (Object)builder.values(v2)), sourceDistinct);
        ValuesNode child2 = builder.values(b);
        return builder.except((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.of((Object)c, (Object)a, (Object)c, (Object)b), (List<PlanNode>)ImmutableList.of((Object)child1, (Object)child2), parentDistinct);
    }
}

