/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergeProjectWithValues;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import org.testng.annotations.Test;

public class TestMergeProjectWithValues
extends BaseRuleTest {
    public TestMergeProjectWithValues() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonRowType() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())), TypeSignatureTranslator.toSqlType((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)))))))).doesNotFire();
    }

    @Test
    public void testProjectWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new CharLiteral("x"), (Object)new BooleanLiteral("true"))), (Object)new Row((List)ImmutableList.of((Object)new CharLiteral("y"), (Object)new BooleanLiteral("false"))))))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values(2));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of(), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values(new String[0]));
    }

    @Test
    public void testValuesWithoutOutputSymbols() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new CharLiteral("x"), (Symbol)p.symbol("b"), (Expression)new BooleanLiteral("true")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of())))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new CharLiteral("x"), (Object)new BooleanLiteral("true")), (Object)ImmutableList.of((Object)new CharLiteral("x"), (Object)new BooleanLiteral("true")))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new CharLiteral("x"), (Symbol)p.symbol("b"), (Expression)new BooleanLiteral("true")), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of()))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of()));
    }

    @Test
    public void testNonDeterministicValues() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"random"), (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("rand"), (Expression)PlanBuilder.expression("rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rand"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)randomFunction))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)PlanBuilder.expression("value")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("value")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new NullLiteral())), (Object)new Row((List)ImmutableList.of((Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)randomFunction))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"output"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)randomFunction), (Object)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)randomFunction)))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("-a"), (Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("b")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new DoubleLiteral("1e0"), (Object)randomFunction)), (Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)new NullLiteral())), (Object)new Row((List)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)randomFunction), (Object)new NullLiteral())))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x", (Object)"y"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new DoubleLiteral("1e0")), (Object)randomFunction), (Object)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)randomFunction), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)randomFunction)), (Object)new NullLiteral()))));
    }

    @Test
    public void testDoNotFireOnNonDeterministicValues() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"random"), (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("rand"), (Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("rand + rand")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))))).doesNotFire();
    }

    @Test
    public void testCorrelation() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("a + corr")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral("1"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral("1"), (Expression)new SymbolReference("corr"))))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("a")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new SymbolReference("corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new SymbolReference("corr")))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)PlanBuilder.expression("1")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new SymbolReference("corr"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))));
    }

    @Test
    public void testFailingExpression() {
        FunctionCall failFunction = LogicalPlanner.failFunction((Metadata)this.tester().getMetadata(), (Session)this.tester().getSession(), (ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (String)"message");
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)failFunction), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral("1"))))))).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)failFunction))));
    }

    @Test
    public void testMergeProjectWithValues() {
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNullPredicate((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new LongLiteral("1"));
            return p.project(assignments.build(), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new CharLiteral("x"), (Object)new BooleanLiteral("true"), (Object)new LongLiteral("1"))), (Object)new Row((List)ImmutableList.of((Object)new CharLiteral("y"), (Object)new BooleanLiteral("false"), (Object)new LongLiteral("2"))), (Object)new Row((List)ImmutableList.of((Object)new CharLiteral("z"), (Object)new BooleanLiteral("true"), (Object)new LongLiteral("3"))))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new CharLiteral("x"), (Object)new BooleanLiteral("true"), (Object)new IsNullPredicate((Expression)new CharLiteral("x")), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new CharLiteral("y"), (Object)new BooleanLiteral("false"), (Object)new IsNullPredicate((Expression)new CharLiteral("y")), (Object)new LongLiteral("1")), (Object)ImmutableList.of((Object)new CharLiteral("z"), (Object)new BooleanLiteral("true"), (Object)new IsNullPredicate((Expression)new CharLiteral("z")), (Object)new LongLiteral("1")))));
        this.tester().assertThat((Rule<?>)new MergeProjectWithValues(this.tester().getMetadata())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentity(a);
            assignments.put(d, (Expression)b.toSymbolReference());
            assignments.put(e, (Expression)new IsNullPredicate((Expression)a.toSymbolReference()));
            assignments.put(f, (Expression)new LongLiteral("1"));
            return p.project(assignments.build(), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b, (Object)c), (List<List<Expression>>)ImmutableList.of()));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"d", (Object)"e", (Object)"f"), (List<List<Expression>>)ImmutableList.of()));
    }
}

