/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneApplyCorrelation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPruneApplyCorrelation
extends BaseRuleTest {
    public TestPruneApplyCorrelation() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneCorrelationSymbolNotReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.values(subquerySymbol));
        }).matches(PlanMatchPattern.apply((List<String>)ImmutableList.of(), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"in_result", (Object)ExpressionMatcher.inPredicate(new SymbolReference("a"), new SymbolReference("subquery_symbol"))), PlanMatchPattern.values("a", "input_symbol"), PlanMatchPattern.values("subquery_symbol")));
    }

    @Test
    public void testAllCorrelationSymbolsReferencedInSubquery() {
        this.tester().assertThat((Rule<?>)new PruneApplyCorrelation()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol inputSymbol = p.symbol("input_symbol");
            Symbol subquerySymbol = p.symbol("subquery_symbol");
            Symbol inResult = p.symbol("in_result");
            return p.apply(Assignments.of((Symbol)inResult, (Expression)new InPredicate((Expression)a.toSymbolReference(), (Expression)subquerySymbol.toSymbolReference())), (List<Symbol>)ImmutableList.of((Object)inputSymbol), (PlanNode)p.values(a, inputSymbol), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)subquerySymbol.toSymbolReference(), (Expression)inputSymbol.toSymbolReference()), (PlanNode)p.values(subquerySymbol)));
        }).doesNotFire();
    }
}

