/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PrunePattenRecognitionColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPrunePattenRecognitionColumns
extends BaseRuleTest {
    public TestPrunePattenRecognitionColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testRemovePatternRecognitionNode() {
        ResolvedFunction rank = MetadataManager.createTestMetadataManager().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"rank"), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED).skipTo(SkipTo.Position.PAST_LAST).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("b")}), (PlanNode)p.patternRecognition(builder -> builder.addWindowFunction(p.symbol("rank"), new WindowNode.Function(rank, (List)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false)).addMeasure(p.symbol("measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testPruneUnreferencedWindowFunctionAndSources() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"lag"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("measure")}), (PlanNode)p.patternRecognition(builder -> builder.addWindowFunction(p.symbol("lag"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("b").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).addMeasure(p.symbol("measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"measure", (Object)PlanMatchPattern.expression("measure")), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("measure", "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testPruneUnreferencedMeasureAndSources() {
        ResolvedFunction lag = MetadataManager.createTestMetadataManager().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"lag"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("lag")}), (PlanNode)p.patternRecognition(builder -> builder.addWindowFunction(p.symbol("lag"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("b").toSymbolReference()), WindowNode.Frame.DEFAULT_FRAME, false)).addMeasure(p.symbol("measure"), "LAST(X.a)", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"lag", (Object)PlanMatchPattern.expression("lag")), PlanMatchPattern.patternRecognition(builder -> builder.addFunction("lag", PlanMatchPattern.functionCall("lag", (List<String>)ImmutableList.of((Object)"b"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipTo.Position.NEXT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPruneVariableDefinitionSources() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), "1", (Type)BigintType.BIGINT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "LAST(X.a) > 0").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "LAST(X.a) > 0"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
        QualifiedName maxBy = this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})).toQualifiedName();
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), "1", (Type)BigintType.BIGINT).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(maxBy, (List)ImmutableList.of((Object)PlanBuilder.expression("a"), (Object)PlanBuilder.expression("b"))), PlanBuilder.expression("5"))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new FunctionCall(maxBy, (List)ImmutableList.of((Object)PlanBuilder.expression("a"), (Object)PlanBuilder.expression("b"))), PlanBuilder.expression("5"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.values("a", "b", "c")))));
    }

    @Test
    public void testDoNotPruneReferencedInputs() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a")}), (PlanNode)p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPrunePartitionBySymbols() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.patternRecognition(builder -> builder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPruneOrderBySymbols() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.patternRecognition(builder -> builder.orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("a")), (Map)ImmutableMap.of((Object)p.symbol("a"), (Object)SortOrder.ASC_NULLS_LAST))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_LAST))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPruneCommonBaseFrameSymbols() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("measure")}), (PlanNode)p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), "1", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBound.Type.FOLLOWING, Optional.of(p.symbol("a")), Optional.empty(), Optional.empty(), Optional.of(p.symbol("a").toSymbolReference()))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"measure", (Object)PlanMatchPattern.expression("measure")), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("measure", "1", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.FOLLOWING, Optional.of("a"), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testDoNotPruneUnreferencedUsedOutputs() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.of(), (PlanNode)p.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "a > 0").source((PlanNode)p.values(p.symbol("a")))))).doesNotFire();
    }

    @Test
    public void testPruneAndMeasures() {
        this.tester().assertThat((Rule<?>)new PrunePattenRecognitionColumns()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a"), p.symbol("b")}), (PlanNode)p.patternRecognition(builder -> builder.addMeasure(p.symbol("measure"), "1", (Type)BigintType.BIGINT).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true").source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.patternRecognition(builder -> builder.rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), "true"), PlanMatchPattern.values("a", "b"))));
    }
}

