/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ValuesNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushLimitThroughMarkDistinct
extends BaseRuleTest {
    public TestPushLimitThroughMarkDistinct() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughMarkDistinct()).on(p -> p.limit(1L, (PlanNode)p.markDistinct(p.symbol("foo"), (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.node(LimitNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testPushLimitWithTies() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughMarkDistinct()).on(p -> p.limit(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("foo")), (PlanNode)p.markDistinct(p.symbol("foo"), (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.node(LimitNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughMarkDistinct()).on(p -> p.markDistinct(p.symbol("foo"), (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.limit(1L, (PlanNode)p.values(new Symbol[0])))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughMarkDistinct()).on(p -> p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("foo")), (PlanNode)p.markDistinct(p.symbol("foo"), (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.values(new Symbol[0])))).doesNotFire();
    }

    @Test
    public void testPushdownLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughMarkDistinct()).on(p -> p.limit(2L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.markDistinct(p.symbol("foo"), (List<Symbol>)ImmutableList.of((Object)p.symbol("bar")), (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.limit(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"bar"), PlanMatchPattern.values(new String[0]))));
    }
}

