/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPushPredicateIntoTableScan
extends BaseRuleTest {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final ConnectorTableHandle CONNECTOR_PARTITIONED_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("schema", "partitioned"));
    private static final ConnectorTableHandle CONNECTOR_PARTITIONED_TABLE_HANDLE_TO_UNPARTITIONED = new MockConnectorTableHandle(new SchemaTableName("schema", "partitioned_to_unpartitioned"));
    private static final ConnectorTableHandle CONNECTOR_UNPARTITIONED_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("schema", "unpartitioned"));
    private static final ConnectorPartitioningHandle PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    private static final ColumnHandle MOCK_COLUMN_HANDLE = new MockConnectorColumnHandle("col", (Type)VarcharType.VARCHAR);
    private PushPredicateIntoTableScan pushPredicateIntoTableScan;
    private CatalogHandle mockCatalogHandle;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();

    public TestPushPredicateIntoTableScan() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getPlannerContext(), TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.tester().getPlannerContext()), false);
        CatalogHandle catalogHandle = this.tester().getCurrentCatalogHandle();
        this.tester().getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)TestPushPredicateIntoTableScan.createMockFactory(), (Map)ImmutableMap.of());
        this.mockCatalogHandle = this.tester().getQueryRunner().getCatalogHandle(MOCK_CATALOG);
        TpchTableHandle nation = new TpchTableHandle("sf1", "nation", 1.0);
        this.nationTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)nation, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
        TpchTableHandle orders = new TpchTableHandle("sf1", "orders", 1.0);
        this.ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)orders, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE);
    }

    @Test
    public void testDoesNotFireIfNoTableScan() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void testEliminateTableScanWhenNoLayoutExist() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'G'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void testReplaceWithExistsWhenNoLayoutExist() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testReplaceWithExistsWhenNoLayoutExist$2((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void testConsumesDeterministicPredicateIfNewDomainIsSame() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testConsumesDeterministicPredicateIfNewDomainIsSame$3((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void testConsumesDeterministicPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testConsumesDeterministicPredicateIfNewDomainIsWider$4((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")));
    }

    @Test
    public void testConsumesDeterministicPredicateIfNewDomainIsNarrower() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        TpchColumnHandle columnHandle = new TpchColumnHandle("orderstatus", (Type)orderStatusType);
        ImmutableMap filterConstraint = ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O")));
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testConsumesDeterministicPredicateIfNewDomainIsNarrower$5((Type)orderStatusType, (ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void testDoesNotConsumeRemainingPredicateIfNewDomainIsWider() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testDoesNotConsumeRemainingPredicateIfNewDomainIsWider$6((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.filter((Expression)LogicalExpression.and((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.functionResolution.functionCallBuilder(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44"))), PlanMatchPattern.constrainedTableScanWithTableLayout("nation", (Map<String, Domain>)ImmutableMap.of((Object)"nationkey", (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)44L)), (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireOnNonDeterministicPredicate() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testDoesNotFireOnNonDeterministicPredicate$7((ColumnHandle)columnHandle, arg_0)).doesNotFire();
    }

    @Test
    public void testDoesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void testRuleAddedTableLayoutToFilterTableScan() {
        ImmutableMap filterConstraint = ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")));
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void testNonDeterministicPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testNonDeterministicPredicate$10((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.functionResolution.functionCallBuilder(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("0")), PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
    }

    @Test
    public void testPartitioningChanged() {
        Session session = Session.builder((Session)this.tester().getSession()).setCatalog(MOCK_CATALOG).build();
        Assertions.assertThatThrownBy(() -> this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).withSession(session).on(p -> p.filter(PlanBuilder.expression("col = VARCHAR 'G'"), (PlanNode)p.tableScan(this.mockTableHandle(CONNECTOR_PARTITIONED_TABLE_HANDLE_TO_UNPARTITIONED), (List<Symbol>)ImmutableList.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR), (Object)MOCK_COLUMN_HANDLE), Optional.of(true)))).matches(PlanMatchPattern.anyTree(new PlanMatchPattern[0]))).hasMessage("Partitioning must not change after predicate is pushed down");
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).withSession(session).on(p -> p.filter(PlanBuilder.expression("col = VARCHAR 'G'"), (PlanNode)p.tableScan(this.mockTableHandle(CONNECTOR_PARTITIONED_TABLE_HANDLE), (List<Symbol>)ImmutableList.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR), (Object)MOCK_COLUMN_HANDLE), Optional.of(true)))).matches(PlanMatchPattern.tableScan("partitioned"));
    }

    @Test
    public void testEliminateTableScanWhenPredicateIsNull() {
        TpchColumnHandle nationKeyColumn = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testEliminateTableScanWhenPredicateIsNull$14((ColumnHandle)nationKeyColumn, arg_0)).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"A"), (List<List<Expression>>)ImmutableList.of()));
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testEliminateTableScanWhenPredicateIsNull$15((ColumnHandle)nationKeyColumn, arg_0)).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"A"), (List<List<Expression>>)ImmutableList.of()));
        this.tester().assertThat((Rule<?>)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$testEliminateTableScanWhenPredicateIsNull$16((ColumnHandle)nationKeyColumn, arg_0)).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"A"), (List<List<Expression>>)ImmutableList.of()));
    }

    public static MockConnectorFactory createMockFactory() {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder();
        builder.withApplyFilter((session, tableHandle, constraint) -> {
            if (tableHandle.equals(CONNECTOR_PARTITIONED_TABLE_HANDLE_TO_UNPARTITIONED)) {
                return Optional.of(new ConstraintApplicationResult((Object)CONNECTOR_UNPARTITIONED_TABLE_HANDLE, TupleDomain.all(), false));
            }
            if (tableHandle.equals(CONNECTOR_PARTITIONED_TABLE_HANDLE)) {
                return Optional.of(new ConstraintApplicationResult((Object)CONNECTOR_PARTITIONED_TABLE_HANDLE, TupleDomain.all(), false));
            }
            return Optional.empty();
        }).withGetTableProperties((session, tableHandle) -> {
            if (tableHandle.equals(CONNECTOR_PARTITIONED_TABLE_HANDLE) || tableHandle.equals(CONNECTOR_PARTITIONED_TABLE_HANDLE_TO_UNPARTITIONED)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(PARTITIONING_HANDLE, (List)ImmutableList.of((Object)MOCK_COLUMN_HANDLE))), Optional.empty(), (List)ImmutableList.of());
            }
            return new ConnectorTableProperties();
        });
        return builder.build();
    }

    private TableHandle mockTableHandle(ConnectorTableHandle connectorTableHandle) {
        return new TableHandle(this.mockCatalogHandle, connectorTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create());
    }

    private /* synthetic */ PlanNode lambda$testEliminateTableScanWhenPredicateIsNull$16(ColumnHandle nationKeyColumn, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44' AND CAST(null AS boolean)"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)nationKeyColumn)));
    }

    private /* synthetic */ PlanNode lambda$testEliminateTableScanWhenPredicateIsNull$15(ColumnHandle nationKeyColumn, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = CAST(null AS BIGINT)"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)nationKeyColumn)));
    }

    private /* synthetic */ PlanNode lambda$testEliminateTableScanWhenPredicateIsNull$14(ColumnHandle nationKeyColumn, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("CAST(null AS boolean)"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)nationKeyColumn)));
    }

    private /* synthetic */ PlanNode lambda$testNonDeterministicPredicate$10(Type orderStatusType, PlanBuilder p) {
        return p.filter((Expression)LogicalExpression.and((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("orderstatus"), (Expression)new StringLiteral("O")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.functionResolution.functionCallBuilder(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("0"))), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$testDoesNotFireOnNonDeterministicPredicate$7(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.functionResolution.functionCallBuilder(QualifiedName.of((String)"rand")).build(), (Expression)new LongLiteral("42")), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.all()));
    }

    private /* synthetic */ PlanNode lambda$testDoesNotConsumeRemainingPredicateIfNewDomainIsWider$6(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.functionResolution.functionCallBuilder(QualifiedName.of((String)"rand")).build(), (Expression)new GenericLiteral("BIGINT", "42")), (Object)new CoalesceExpression((Expression)new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MODULUS, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "17")), (Expression)new GenericLiteral("BIGINT", "44")), new Expression[0]), (Object)LogicalExpression.or((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "44")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("nationkey"), (Expression)new GenericLiteral("BIGINT", "45"))))), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$testConsumesDeterministicPredicateIfNewDomainIsNarrower$5(Type orderStatusType, ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O' OR orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType)), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnHandle, (Object)Domain.multipleValues((Type)orderStatusType, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"O"), (Object)Slices.utf8Slice((String)"P")))))));
    }

    private /* synthetic */ PlanNode lambda$testConsumesDeterministicPredicateIfNewDomainIsWider$4(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44' OR nationkey = BIGINT '45'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$testConsumesDeterministicPredicateIfNewDomainIsSame$3(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)44L)))));
    }

    private /* synthetic */ PlanNode lambda$testReplaceWithExistsWhenNoLayoutExist$2(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)columnHandle, (Object)NullableValue.of((Type)BigintType.BIGINT, (Object)45L)))));
    }
}

