/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantExists;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoveRedundantExists
extends BaseRuleTest {
    public TestRemoveRedundantExists() {
        super(new Plugin[0]);
    }

    @Test
    public void testExistsFalse() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("exists"), (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, new Symbol[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"exists", (Object)PlanMatchPattern.expression("false")), PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testExistsTrue() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("exists"), (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(1, new Symbol[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"exists", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply(Assignments.of((Symbol)p.symbol("exists"), (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply(Assignments.builder().put(p.symbol("exists"), (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)).put(p.symbol("other"), (Expression)new InPredicate((Expression)new SymbolReference("value"), (Expression)new SymbolReference("list"))).build(), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, p.symbol("value")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("list")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("list"), (Object)new TestingMetadata.TestingColumnHandle("list"))))).doesNotFire();
    }
}

