/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithSource;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.NullLiteral;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestReplaceRedundantJoinWithSource
extends BaseRuleTest {
    public TestReplaceRedundantJoinWithSource() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnJoinWithEmptySource() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, p.symbol("a")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnJoinWithNoScalarSource() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testReplaceCrossJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
    }

    @Test
    public void testReplaceInnerJoinWithFilter() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), PlanBuilder.expression("a > 0"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.filter("a > 0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), PlanBuilder.expression("b > 0"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.filter("b > 0", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testReplaceLeftJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), PlanBuilder.expression("a > 0"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
    }

    @Test
    public void testReplaceRightJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), PlanBuilder.expression("b > 0"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
    }

    @Test
    public void testReplaceFullJoin() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), PlanBuilder.expression("b > 0"), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral()))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.values(10, p.symbol("a"))), (PlanNode)p.values(1, new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.filter(PlanBuilder.expression("a > 5"), (PlanNode)p.values(10, p.symbol("a"))), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testPruneOutputs() {
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.LEFT, (PlanNode)p.values(10, a, b), (PlanNode)p.values(1, new Symbol[0]), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of(), Optional.of(PlanBuilder.expression("a > b")));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())))));
        this.tester().assertThat((Rule<?>)new ReplaceRedundantJoinWithSource()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(10, a, b), (PlanNode)p.values(1, new Symbol[0]), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)a), (List<Symbol>)ImmutableList.of(), Optional.of(PlanBuilder.expression("a > b")));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a")), PlanMatchPattern.filter("a > b", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), Collections.nCopies(10, ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral()))))));
    }
}

