/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestTransformCorrelatedGlobalAggregationWithoutProjection
extends BaseRuleTest {
    public TestTransformCorrelatedGlobalAggregationWithoutProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnPlanWithoutCorrelatedJoinNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithoutAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonScalarAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(p.symbol("b"))))).doesNotFire();
    }

    @Test
    public void doesNotFireOnMultipleProjections() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_2"), (Expression)PlanBuilder.expression("expr - 1")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"sum_1", (Object)PlanMatchPattern.expression("sum_1"), (Object)"corr", (Object)PlanMatchPattern.expression("corr")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"sum_1", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void rewritesOnSubqueryWithProjection() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr"), (Expression)PlanBuilder.expression("sum + 1")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).doesNotFire();
    }

    @Test
    public void testSubqueryWithCount() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("count_rows"), PlanBuilder.expression("count(*)"), (List<Type>)ImmutableList.of()).addAggregation(p.symbol("count_non_null_values"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping()))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_rows", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of()), (Object)"count_non_null_values", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b > corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"sum_agg", (Object)PlanMatchPattern.expression("sum_agg"), (Object)"count_agg", (Object)PlanMatchPattern.expression("count_agg")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "non_null", "a"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.filter("b > corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.addAggregation(p.symbol("sum"), PlanBuilder.expression("sum(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).globalGrouping().source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter(PlanBuilder.expression("b = corr"), (PlanNode)p.values(p.symbol("a"), p.symbol("b"))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression("corr"), (Object)"sum_agg", (Object)PlanMatchPattern.expression("sum_agg"), (Object)"count_agg", (Object)PlanMatchPattern.expression("count_agg")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.filter("b = corr").left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter("true", PlanMatchPattern.values("a", "b")))))))));
    }

    @Test
    public void testWithPreexistingMask() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGlobalAggregationWithoutProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("mask"))).addAggregation(p.symbol("count_non_null_values"), PlanBuilder.expression("count(a)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), p.symbol("mask")).globalGrouping()))).matches(PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("count_non_null_values"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"a"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"new_mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"new_mask", (Object)PlanMatchPattern.expression("mask AND non_null")), PlanMatchPattern.join(JoinNode.Type.LEFT, builder -> builder.left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"corr", (Object)0)))).right(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"a", (Object)0, (Object)"mask", (Object)1)))))))));
    }
}

