/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.GroupingProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.connector.SortingProperty;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.testing.TestingMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalProperties {
    @Test
    public void testConstantProcessing() {
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)ImmutableList.of()), (Collection)ImmutableList.of());
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)ImmutableList.of()), (Set)ImmutableSet.of());
        ImmutableList input = ImmutableList.of(TestLocalProperties.grouped("a"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)ImmutableList.of(TestLocalProperties.grouped("a")));
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of());
        input = ImmutableList.of(TestLocalProperties.constant("b"), TestLocalProperties.grouped("a"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)ImmutableList.of(TestLocalProperties.grouped("a")));
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of((Object)"b"));
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.grouped("a"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)ImmutableList.of(TestLocalProperties.grouped("a")));
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of((Object)"a"));
        input = ImmutableList.of(TestLocalProperties.grouped("a"), TestLocalProperties.constant("b"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)input);
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of());
        input = ImmutableList.of(TestLocalProperties.constant("a"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)ImmutableList.of());
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of((Object)"a"));
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.constant("b"));
        Assert.assertEquals((Collection)LocalProperties.stripLeadingConstants((List)input), (Collection)ImmutableList.of());
        Assert.assertEquals((Set)LocalProperties.extractLeadingConstants((List)input), (Set)ImmutableSet.of((Object)"a", (Object)"b"));
    }

    @Test
    public void testTranslate() {
        ImmutableMap map = ImmutableMap.of();
        ImmutableList input = ImmutableList.of();
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of());
        map = ImmutableMap.of();
        input = ImmutableList.of(TestLocalProperties.grouped("a"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of());
        map = ImmutableMap.of((Object)"a", (Object)"a1");
        input = ImmutableList.of(TestLocalProperties.grouped("a"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1")));
        map = ImmutableMap.of();
        input = ImmutableList.of(TestLocalProperties.constant("a"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of());
        map = ImmutableMap.of();
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.grouped("b"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of());
        map = ImmutableMap.of((Object)"b", (Object)"b1");
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.grouped("b"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("b1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"b", (Object)"b1");
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.grouped("b"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.constant("a1"), TestLocalProperties.grouped("b1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"b", (Object)"b1");
        input = ImmutableList.of(TestLocalProperties.grouped("a", "b"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1", "b1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.constant("a"), TestLocalProperties.grouped("b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.constant("a1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.grouped("a", "b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of());
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.grouped("a"), TestLocalProperties.grouped("b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.constant("b"), TestLocalProperties.grouped("a", "b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1"), TestLocalProperties.grouped("c1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.grouped("a"), TestLocalProperties.constant("b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1"), TestLocalProperties.grouped("c1")));
        map = ImmutableMap.of((Object)"a", (Object)"a1", (Object)"b", (Object)"b1", (Object)"c", (Object)"c1");
        input = ImmutableList.of(TestLocalProperties.grouped("a"), TestLocalProperties.constant("b"), TestLocalProperties.grouped("c"));
        Assert.assertEquals((Collection)LocalProperties.translate((List)input, TestLocalProperties.translateWithMap(map)), (Collection)ImmutableList.of(TestLocalProperties.grouped("a1"), TestLocalProperties.constant("b1"), TestLocalProperties.grouped("c1")));
    }

    private static <X, Y> Function<X, Optional<Y>> translateWithMap(Map<X, Y> translateMap) {
        return input -> Optional.ofNullable(translateMap.get(input));
    }

    @Test
    public void testNormalizeEmpty() {
        List localProperties = TestLocalProperties.builder().build();
        TestLocalProperties.assertNormalize(localProperties, new Optional[0]);
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[0]);
    }

    @Test
    public void testNormalizeSingleSmbolGroup() {
        List localProperties = TestLocalProperties.builder().grouped("a").build();
        TestLocalProperties.assertNormalize(localProperties, Optional.of(TestLocalProperties.grouped("a")));
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[]{TestLocalProperties.grouped("a")});
    }

    @Test
    public void testNormalizeOverlappingSymbol() {
        List localProperties = TestLocalProperties.builder().grouped("a").sorted("a", SortOrder.ASC_NULLS_FIRST).constant("a").build();
        TestLocalProperties.assertNormalize(localProperties, Optional.of(TestLocalProperties.grouped("a")), Optional.empty(), Optional.empty());
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[]{TestLocalProperties.grouped("a")});
    }

    @Test
    public void testNormalizeComplexWithLeadingConstant() {
        List localProperties = TestLocalProperties.builder().constant("a").grouped("a", "b").grouped("b", "c").sorted("c", SortOrder.ASC_NULLS_FIRST).build();
        TestLocalProperties.assertNormalize(localProperties, Optional.of(TestLocalProperties.constant("a")), Optional.of(TestLocalProperties.grouped("b")), Optional.of(TestLocalProperties.grouped("c")), Optional.empty());
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[]{TestLocalProperties.constant("a"), TestLocalProperties.grouped("b"), TestLocalProperties.grouped("c")});
    }

    @Test
    public void testNormalizeComplexWithMiddleConstant() {
        List localProperties = TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).grouped("a", "b").grouped("c").constant("a").build();
        TestLocalProperties.assertNormalize(localProperties, Optional.of(TestLocalProperties.sorted("a", SortOrder.ASC_NULLS_FIRST)), Optional.of(TestLocalProperties.grouped("b")), Optional.of(TestLocalProperties.grouped("c")), Optional.empty());
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[]{TestLocalProperties.sorted("a", SortOrder.ASC_NULLS_FIRST), TestLocalProperties.grouped("b"), TestLocalProperties.grouped("c")});
    }

    @Test
    public void testNormalizeDifferentSorts() {
        List localProperties = TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).sorted("a", SortOrder.DESC_NULLS_LAST).build();
        TestLocalProperties.assertNormalize(localProperties, Optional.of(TestLocalProperties.sorted("a", SortOrder.ASC_NULLS_FIRST)), Optional.empty());
        TestLocalProperties.assertNormalizeAndFlatten(localProperties, new LocalProperty[]{TestLocalProperties.sorted("a", SortOrder.ASC_NULLS_FIRST)});
    }

    @Test
    public void testMatchedGroupHierarchy() {
        List actual = TestLocalProperties.builder().grouped("a").grouped("b").grouped("c").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.of(TestLocalProperties.grouped("b")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b", "c").build(), Optional.of(TestLocalProperties.grouped("b", "c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "c").build(), Optional.of(TestLocalProperties.grouped("c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("c").build(), Optional.of(TestLocalProperties.grouped("c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").grouped("a").grouped("a").grouped("a").grouped("b").build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Test
    public void testGroupedTuple() {
        List actual = TestLocalProperties.builder().grouped("a", "b", "c").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.of(TestLocalProperties.grouped("a", "b")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.of(TestLocalProperties.grouped("a")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").grouped("b").build(), Optional.of(TestLocalProperties.grouped("a")), Optional.of(TestLocalProperties.grouped("b")));
    }

    @Test
    public void testGroupedDoubleThenSingle() {
        List actual = TestLocalProperties.builder().grouped("a", "b").grouped("c").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "c").build(), Optional.of(TestLocalProperties.grouped("a", "c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.of(TestLocalProperties.grouped("a")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("c").build(), Optional.of(TestLocalProperties.grouped("c")));
    }

    @Test
    public void testGroupedDoubleThenDouble() {
        List actual = TestLocalProperties.builder().grouped("a", "b").grouped("c", "a").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b", "c").build(), Optional.of(TestLocalProperties.grouped("b", "c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.of(TestLocalProperties.grouped("a")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("c").build(), Optional.of(TestLocalProperties.grouped("c")));
    }

    @Test
    public void testSortProperties() {
        List actual = TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).sorted("b", SortOrder.ASC_NULLS_FIRST).sorted("c", SortOrder.ASC_NULLS_FIRST).build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b", "c").build(), Optional.of(TestLocalProperties.grouped("b", "c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.of(TestLocalProperties.grouped("b")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).sorted("c", SortOrder.ASC_NULLS_FIRST).build(), Optional.empty(), Optional.of(TestLocalProperties.sorted("c", SortOrder.ASC_NULLS_FIRST)));
    }

    @Test
    public void testSortGroupSort() {
        List actual = TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).grouped("b", "c").sorted("d", SortOrder.ASC_NULLS_FIRST).build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d", "e").build(), Optional.of(TestLocalProperties.grouped("e")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.of(TestLocalProperties.grouped("b")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.of(TestLocalProperties.grouped("b")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).sorted("b", SortOrder.ASC_NULLS_FIRST).build(), Optional.empty(), Optional.of(TestLocalProperties.sorted("b", SortOrder.ASC_NULLS_FIRST)));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).grouped("b", "c", "d").grouped("e", "a").build(), Optional.empty(), Optional.empty(), Optional.of(TestLocalProperties.grouped("e")));
    }

    @Test
    public void testPartialConstantGroup() {
        List actual = TestLocalProperties.builder().constant("a").grouped("a", "b").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.of(TestLocalProperties.grouped("c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.empty());
    }

    @Test
    public void testNonoverlappingConstantGroup() {
        List actual = TestLocalProperties.builder().constant("a").grouped("b").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.of(TestLocalProperties.grouped("c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").grouped("a").build(), Optional.empty(), Optional.empty());
    }

    @Test
    public void testConstantWithMultiGroup() {
        List actual = TestLocalProperties.builder().constant("a").grouped("a", "b").grouped("a", "c").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "c").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "c").build(), Optional.of(TestLocalProperties.grouped("c")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b").build(), Optional.empty());
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("b", "c").build(), Optional.empty());
    }

    @Test
    public void testConstantWithSort() {
        List actual = TestLocalProperties.builder().constant("b").sorted("a", SortOrder.ASC_NULLS_FIRST).sorted("b", SortOrder.ASC_NULLS_FIRST).sorted("c", SortOrder.ASC_NULLS_FIRST).build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "b", "d").build(), Optional.of(TestLocalProperties.grouped("d")));
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a", "c").build(), Optional.empty());
    }

    @Test
    public void testMoreRequiredGroupsThanActual() {
        List actual = TestLocalProperties.builder().constant("b").grouped("a").grouped("d").build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().grouped("a").grouped("b").grouped("c").grouped("d").build(), Optional.empty(), Optional.empty(), Optional.of(TestLocalProperties.grouped("c")), Optional.of(TestLocalProperties.grouped("d")));
    }

    @Test
    public void testDifferentSortOrders() {
        List actual = TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_FIRST).build();
        TestLocalProperties.assertMatch(actual, TestLocalProperties.builder().sorted("a", SortOrder.ASC_NULLS_LAST).build(), Optional.of(TestLocalProperties.sorted("a", SortOrder.ASC_NULLS_LAST)));
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(ColumnHandle.class, (JsonDeserializer)new JsonDeserializer<ColumnHandle>(){

            public ColumnHandle deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return (ColumnHandle)new ObjectMapperProvider().get().readValue(jsonParser, TestingMetadata.TestingColumnHandle.class);
            }
        }));
        TestingMetadata.TestingColumnHandle columnHandle = new TestingMetadata.TestingColumnHandle("a");
        ConstantProperty property1 = new ConstantProperty((Object)columnHandle);
        Assert.assertEquals((Object)property1, (Object)mapper.readValue(mapper.writeValueAsString((Object)property1), (TypeReference)new TypeReference<LocalProperty<ColumnHandle>>(){}));
        SortingProperty property2 = new SortingProperty((Object)columnHandle, SortOrder.ASC_NULLS_FIRST);
        Assert.assertEquals((Object)property2, (Object)mapper.readValue(mapper.writeValueAsString((Object)property2), (TypeReference)new TypeReference<LocalProperty<ColumnHandle>>(){}));
        GroupingProperty property3 = new GroupingProperty((Collection)ImmutableList.of((Object)columnHandle));
        Assert.assertEquals((Object)property3, (Object)mapper.readValue(mapper.writeValueAsString((Object)property3), (TypeReference)new TypeReference<LocalProperty<ColumnHandle>>(){}));
    }

    @SafeVarargs
    private static <T> void assertMatch(List<LocalProperty<T>> actual, List<LocalProperty<T>> wanted, Optional<LocalProperty<T>> ... match) {
        Assert.assertEquals((Collection)LocalProperties.match(actual, wanted), Arrays.asList(match));
    }

    @SafeVarargs
    private static <T> void assertNormalize(List<LocalProperty<T>> localProperties, Optional<LocalProperty<T>> ... normalized) {
        Assert.assertEquals((Collection)LocalProperties.normalize(localProperties), Arrays.asList(normalized));
    }

    @SafeVarargs
    private static <T> void assertNormalizeAndFlatten(List<LocalProperty<T>> localProperties, LocalProperty<T> ... normalized) {
        Assert.assertEquals((Collection)LocalProperties.normalizeAndPrune(localProperties), Arrays.asList(normalized));
    }

    private static ConstantProperty<String> constant(String column) {
        return new ConstantProperty((Object)column);
    }

    private static GroupingProperty<String> grouped(String ... columns) {
        return new GroupingProperty(Arrays.asList(columns));
    }

    private static SortingProperty<String> sorted(String column, SortOrder order) {
        return new SortingProperty((Object)column, order);
    }

    private static Builder builder() {
        return new Builder();
    }

    private static class Builder {
        private final List<LocalProperty<String>> properties = new ArrayList<LocalProperty<String>>();

        private Builder() {
        }

        public Builder grouped(String ... columns) {
            this.properties.add((LocalProperty<String>)new GroupingProperty(Arrays.asList(columns)));
            return this;
        }

        public Builder sorted(String column, SortOrder order) {
            this.properties.add((LocalProperty<String>)new SortingProperty((Object)column, order));
            return this;
        }

        public Builder constant(String column) {
            this.properties.add((LocalProperty<String>)new ConstantProperty((Object)column));
            return this;
        }

        public List<LocalProperty<String>> build() {
            return new ArrayList<LocalProperty<String>>(this.properties);
        }
    }
}

