/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestSelectAll {
    private QueryAssertions assertions;
    private static final String UNSUPPORTED_DECORRELATION_MESSAGE = ".*: Given correlated subquery is not supported";

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testSelectAllFromRow() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT alias1, alias2 FROM (SELECT CAST((ROW (1, 'a')) AS ROW (f1 bigint, f2 varchar(1))).* AS (alias1, alias2)) t")))).matches("SELECT BIGINT '1' alias1, 'a' alias2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT alias1, alias2 FROM (SELECT (ROW (1, 'a')).* AS (alias1, alias2)) t")))).matches("SELECT 1 alias1, 'a' alias2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT f1, f2 FROM (SELECT CAST((ROW (1, 'a')) AS ROW (f1 bigint, f2 varchar(1))).*) t")))).matches("SELECT BIGINT '1' f1, 'a' f2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT f1 FROM (SELECT t.r.* FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 integer))), ROW(CAST(ROW(2) AS ROW(f1 integer)))) t(r))")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (ROW (1, 'a')).*")))).matches("SELECT 1, 'a'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a.b.* FROM (VALUES (ROW (ROW (1, 2, 3)))) A (b)")))).matches("SELECT 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT b[1][1].* FROM (VALUES (ROW (ROW (ROW ( ROW (1, 2, 3)))))) A (b)")))).matches("SELECT 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (1, 2).*, 3")))).matches("SELECT 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT *, (x, 2*x).* AS (a, b), 3*x AS c FROM (VALUES 1) t(x)")))).matches("SELECT 1, 1 a, 2 b, 3 c");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT ROW(a, b).*, ROW(b, c).*, ROW(a, c).* FROM (VALUES (1, 2, 3)) t(a, b, c)")))).matches("VALUES (1, 2, 2, 3, 1, 3)");
        MaterializedResult materializedResult = this.assertions.execute("SELECT (x, x, x, x, x, x, x, x).* FROM (SELECT rand()) T(x)");
        long distinctValuesCount = ((MaterializedRow)materializedResult.getMaterializedRows().get(0)).getFields().stream().distinct().count();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)distinctValuesCount, (String)"rand() must be computed once only");
        MaterializedResult materializedResult1 = this.assertions.execute("SELECT (SELECT (rand(), rand(), rand(), rand())).*");
        long distinctValuesCount1 = ((MaterializedRow)materializedResult1.getMaterializedRows().get(0)).getFields().stream().distinct().count();
        org.junit.jupiter.api.Assertions.assertTrue((distinctValuesCount1 >= 3L ? 1 : 0) != 0, (String)"rand() must be computed multiple times");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1, (2, 3).*")))).matches("SELECT 1, 2, 3");
    }

    @Test
    public void testSelectAllFromTable() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a, b, c FROM (SELECT T.* FROM (VALUES (1, 2, 3)) T (a, b, c))")))).matches("SELECT 1 a, 2 b, 3 c");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a, b, c FROM (SELECT T.* AS (a, b, c) FROM (VALUES (1, 2, 3)) T (x, y, z))")))).matches("SELECT 1 a, 2 b, 3 c");
    }

    @Test
    public void testSelectAllWithOrderBy() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(ROW(1, 'a', true)), ROW(ROW(2, 'b', false))) t(r) ORDER BY 2 DESC")))).ordered().matches("VALUES (2, 'b', false), (1, 'a', true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* AS (x, y, z) FROM (VALUES ROW(ROW(1, 'a', true)), ROW(ROW(2, 'b', false))) t(r) ORDER BY y DESC")))).ordered().matches("VALUES (2, 'b', false), (1, 'a', true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 integer))), ROW(CAST(ROW(2) AS ROW(f1 integer)))) t(r) ORDER BY 1 DESC")))).ordered().matches("VALUES 2, 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 integer))), ROW(CAST(ROW(2) AS ROW(f1 integer)))) t(r) ORDER BY f1 DESC")))).ordered().matches("VALUES 2, 1");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT t.r.* FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 integer))), ROW(CAST(ROW(2) AS ROW(f2 integer)))) t(r) ORDER BY f1 DESC")).hasMessageMatching(".*Column 'f1' cannot be resolved");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* AS (f1) FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 integer))), ROW(CAST(ROW(2) AS ROW(f2 integer)))) t(r) ORDER BY f1 DESC")))).ordered().matches("VALUES 2, 1");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT t.r.* AS (x) FROM (VALUES ROW(CAST(ROW(1) AS ROW(f1 bigint))), ROW(CAST(ROW(2) AS ROW(f1 bigint)))) t(r) ORDER BY f1 DESC")).hasMessageMatching(".*Column 'f1' cannot be resolved");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* AS (x, y, z) FROM (VALUES ROW(ROW(1, 'a', true)), ROW(ROW(2, 'b', false))) t(r) ORDER BY r DESC")))).ordered().matches("VALUES (2, 'b', false), (1, 'a', true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT *, t.r.* AS (x, y) FROM (VALUES ROW(ROW('a', true)), ROW(ROW('b', false))) t(r) ORDER BY y")))).ordered().matches("VALUES (ROW('b', false), 'b', false), (ROW('a', true), 'a', true)");
    }

    @Test
    public void testSelectAllWithGroupBy() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(ROW(1, 'a', true)), ROW(ROW(1, 'a', true))) t(r) GROUP BY r")))).matches("VALUES (1, 'a', true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(ROW('a', true)), ROW(ROW('a', true)), ROW(ROW('a', false)), ROW(ROW('b', true))) t(r) GROUP BY r")))).matches("VALUES ('a', true), ('a', false), ('b', true)");
    }

    @Test
    public void testSelectAllWithAggregationAndOrderBy() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.r.* FROM (VALUES ROW(ROW(1, 'a', true)), ROW(ROW(2, 'b', false))) t(r) GROUP BY r ORDER BY r DESC")))).ordered().matches("VALUES (2, 'b', false), (1, 'a', true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT r, x, count(x), t.r.* FROM (VALUES (ROW(1), 'a'), (ROW(2), 'b'), (ROW(1), 'a'), (ROW(1), 'b')) t(r, x) GROUP BY r, x ORDER BY r, x DESC")))).ordered().matches("VALUES (ROW(1), 'b', BIGINT '1', 1), (ROW(1), 'a', 2, 1), (ROW(2), 'b', 1, 2)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT array_agg(x), t.r.* FROM (VALUES (ROW(1), 'a'), (ROW(2), 'b'), (ROW(1), 'a'), (ROW(1), 'b')) t(r, x) GROUP BY r, x ORDER BY r, x DESC")))).ordered().matches("VALUES (ARRAY['b'], 1), (ARRAY['a', 'a'], 1), (ARRAY['b'], 2)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT array_agg(x), t.r.* FROM (VALUES (ROW(1), 'a'), (ROW(2), 'b'), (ROW(1), 'a'), (ROW(1), 'b')) t(r, x) GROUP BY r ORDER BY r DESC")))).ordered().matches("VALUES (ARRAY['b'], 2), (ARRAY['a', 'a', 'b'], 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT array_agg(x), t.r.* FROM (VALUES (ROW(1, true), 'a'), (ROW(2, false), 'b'), (ROW(1, true), 'c')) t(r, x) GROUP BY r ORDER BY r[2]")))).ordered().matches("VALUES (ARRAY['b'], 2, false), (ARRAY['a', 'c'], 1, true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT array_agg(r[2]), t.r.* FROM (VALUES ROW(ROW(1, true)), ROW(ROW(2, false)), ROW(ROW(1, true))) t(r) GROUP BY r ORDER BY r[2]")))).ordered().matches("VALUES (ARRAY[false], 2, false), (ARRAY[true, true], 1, true)");
    }

    @Test
    public void testSelectAllFromOuterScopeTable() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.*) FROM (VALUES 1, 2) t(a)")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (SELECT 'a', 'b')) FROM (VALUES 1, 2) t(a)")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0)) FROM (VALUES 1, 2) t(a)")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0)) FROM (SELECT * FROM (VALUES 1, 1, 1) LIMIT 2) t(a)")))).matches("VALUES 1, 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0)) FROM (VALUES (1, 1), (2, 2)) t(a, b)")))).matches("VALUES CAST(ROW(ROW(1, 1)) AS row(row(a integer, b integer))), CAST(ROW(ROW(2, 2)) AS row(row(a integer, b integer)))");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0, 1)) FROM (VALUES 2) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) WHERE true) FROM (VALUES 1) t(a)")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) WHERE 0 = 0) FROM (VALUES 1) t(a)")))).matches("VALUES 1");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) t2(b) WHERE b > 1) FROM (VALUES 1) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) WHERE false) FROM (VALUES 1) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) LIMIT 1) FROM (VALUES 1, 2) t(a)")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) LIMIT 5) FROM (VALUES 1, 2) t(a)")))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) LIMIT 0) FROM (VALUES 1, 2) t(a)")))).matches("VALUES CAST(NULL AS INTEGER), CAST(NULL AS INTEGER)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0, 1) LIMIT 1) FROM (VALUES 2, 3) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT (SELECT t.* FROM (SELECT * FROM (VALUES 0, 1) LIMIT 1)) FROM (VALUES 2, 3) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 0) t) FROM (VALUES 1) t(a)")))).matches("VALUES 0");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT(SELECT(SELECT t.* FROM (VALUES 0)) FROM (VALUES 1) t(a)) FROM (VALUES 2) t(a)")))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT t.* FROM (VALUES 0)) FROM (VALUES 1, 2) t(a)")))).matches("VALUES true, true");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT t.* FROM (VALUES 1) t2(b) WHERE t2.b > t.a) FROM (VALUES 0, 2) t(a)")))).matches("VALUES true, false");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT 1 IN (SELECT t.*) FROM (VALUES 1, 2) t(a)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.*)")))).matches("VALUES (0, 0), (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.a, t2.d FROM (VALUES (0, 1), (2, 3)) t(a, b), LATERAL (SELECT t.*) t2(c, d)")))).matches("VALUES (0, 1), (2, 3)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* LIMIT 5)")))).matches("VALUES (0, 0), (1, 1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* LIMIT 0)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* WHERE true)")))).matches("VALUES (0, 0), (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* WHERE 0 = 0)")))).matches("VALUES (0, 0), (1, 1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* WHERE false)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* WHERE t.a = 0)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* FROM (VALUES 1))")))).matches("VALUES (0, 0), (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT t.* FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.*) t")))).matches("VALUES (0, 0), (1, 1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* FROM (VALUES 1, 2))")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* FROM (VALUES 1, 2) LIMIT 1)")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t.* FROM (SELECT * FROM (VALUES 1, 2) LIMIT 1))")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t2.* from (VALUES 3, 4) t2(b), LATERAL (SELECT t.*))")))).matches("VALUES (0, 3), (1, 3), (0, 4), (1, 4)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t2.* from (VALUES 2), LATERAL (SELECT t.*) t2(b))")))).matches("VALUES (0, 0), (1, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT t2.b from (VALUES 2), LATERAL (SELECT t.*) t2(b))")))).matches("VALUES (0, 0), (1, 1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 0) t(a), LATERAL (SELECT t2.* from (VALUES 1, 2), LATERAL (SELECT t.*) t2(b))")).hasMessageMatching(UNSUPPORTED_DECORRELATION_MESSAGE);
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 0, 1) t(a), LATERAL (SELECT * from (VALUES 2), LATERAL (SELECT t.*))")))).matches("VALUES (0, 2, 0), (1, 2, 1)");
    }
}

