/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestSetOperations {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testExceptInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2, 3    EXCEPT    VALUES 1)")))).matches("VALUES 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2, 2, 3    EXCEPT ALL    VALUES 1, 2, 2)")))).matches("VALUES 1, 3");
    }

    @Test
    public void testIntersectInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2    INTERSECT    VALUES 2, 3)")))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3) SELECT * FROM t WHERE id IN (    VALUES 1, 1, 2    INTERSECT ALL    VALUES 2, 3)")))).matches("VALUES 2");
    }

    @Test
    public void testUnionInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3, 4) SELECT * FROM t WHERE id IN (    VALUES 1, 2    UNION    VALUES 2, 3)")))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(id) AS (VALUES 1, 2, 3, 4) SELECT * FROM t WHERE id IN (    VALUES 1, 2    UNION ALL    VALUES 2, 3)")))).matches("VALUES 1, 2, 3");
    }

    @Test
    public void testUnionAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3        UNION        VALUES 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3        UNION ALL        VALUES 3, 4    ) t(v))")))).matches("VALUES (ARRAY[1, 2, 3, 4], ARRAY[1, 2, 3, 3, 4])");
    }

    @Test
    public void testIntersectAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3, 3        INTERSECT        VALUES 2, 2, 3, 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 2, 3, 3        INTERSECT ALL        VALUES 2, 2, 3, 3, 4    ) t(v))")))).matches("VALUES (ARRAY[2, 3], ARRAY[2, 3, 3])");
    }

    @Test
    public void testExceptAllVsDistinctInSubquery() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 1, 2, 2, 3, 3        EXCEPT        VALUES 2, 3, 3, 4    ) t(v)),    (    SELECT array_agg(v ORDER BY v) FROM (        VALUES 1, 1, 2, 2, 3, 3        EXCEPT ALL        VALUES 2, 3, 3, 4    ) t(v))")))).matches("VALUES (ARRAY[1], ARRAY[1, 1, 2])");
    }

    @Test
    public void testExceptWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false EXCEPT ALL SELECT 1 WHERE false EXCEPT ALL SELECT 2 WHERE false")))).describedAs("EXCEPT ALL with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false EXCEPT DISTINCT SELECT 1 WHERE false EXCEPT DISTINCT SELECT 2 WHERE false")))).describedAs("EXCEPT DISTINCT with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 EXCEPT ALL SELECT 1 WHERE false EXCEPT ALL SELECT 2 WHERE false")))).describedAs("EXCEPT ALL with empty subtractions", new Object[0]))).matches("VALUES 1, 1, 2, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 EXCEPT DISTINCT SELECT 1 WHERE false EXCEPT DISTINCT SELECT 2 WHERE false ")))).describedAs("EXCEPT DISTINCT with empty subtractions", new Object[0]))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 WHERE false EXCEPT ALL VALUES 2, 3")))).describedAs("EXCEPT ALL with empty set", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 1 WHERE false EXCEPT DISTINCT VALUES 2, 3")))).describedAs("EXCEPT DISTINCT with empty set", new Object[0]))).returnsEmptyResult();
    }

    @Test
    public void testUnionWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false UNION ALL SELECT 0 WHERE false")))).describedAs("UNION ALL with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false UNION DISTINCT SELECT 0 WHERE false")))).describedAs("UNION DISTINCT with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION ALL VALUES 1, 3, 3, 4 UNION ALL SELECT 0 WHERE false")))).describedAs("UNION ALL with empty branches", new Object[0]))).matches("VALUES 1, 1, 1, 2, 2, 3, 3, 3, 4");
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION DISTINCT VALUES 1, 3, 3, 4 UNION DISTINCT SELECT 0 WHERE false")))).describedAs("UNION DISTINCT with empty branches", new Object[0]))).matches("VALUES 1, 2, 3, 4");
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION DISTINCT SELECT 0 WHERE false UNION DISTINCT SELECT 0 WHERE false")))).describedAs("UNION DISTINCT with single non-empty branch", new Object[0]))).matches("VALUES 1, 2, 3");
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 UNION ALL SELECT 0 WHERE false UNION ALL SELECT 0 WHERE false")))).describedAs("UNION ALL with single non-empty branch", new Object[0]))).matches("VALUES 1, 1, 2, 2, 3");
    }

    @Test
    public void testIntersectWithEmptyBranches() {
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false INTERSECT ALL SELECT 0 WHERE false")))).describedAs("INTERSECT ALL with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 0 WHERE false INTERSECT DISTINCT SELECT 0 WHERE false")))).describedAs("INTERSECT DISTINCT with all empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 INTERSECT ALL SELECT 0 WHERE false")))).describedAs("INTERSECT ALL with empty branches", new Object[0]))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)((Object)((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 1, 2, 2, 3 INTERSECT DISTINCT SELECT 0 WHERE false")))).describedAs("INTERSECT DISTINCT with empty branches", new Object[0]))).returnsEmptyResult();
    }
}

