/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestValues {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testRowSpecifications() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 2")))).matches("VALUES ROW(1), ROW(2)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES (1, 'a')")))).matches("VALUES ROW(1, 'a')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 'TruE') AS row(double, boolean))")))).matches("VALUES ROW(1e0, true)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 'TruE') AS row(double, boolean)), ROW(2e0, false), (3e0, null)")))).matches("VALUES ROW(1e0, true),ROW(2e0, false), ROW(3e0, null)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT key FROM (VALUES CAST(ROW(1, 'TruE') AS row(double, boolean)), ROW(2e0, false), (3e0, null)) T(key, value)")))).matches("VALUES 1e0, 2e0, 3e0");
    }

    @Test
    public void testCoercions() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES 1, 2e0")))).matches("VALUES ROW(1e0), ROW(2e0)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES (1, 2), (3, 4e0)")))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 2) AS row(integer, smallint)), (3, 4e0)")))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, 2) AS row(integer, double)), (3, 4)")))).matches("VALUES ROW(1, 2e0), ROW(3, 4e0)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(1, null) AS row(integer, double)), (3, 4)")))).matches("VALUES ROW(1, null), ROW(3, 4e0)");
    }

    @Test
    public void testNulls() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES null")))).matches("VALUES ROW(null)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES (null, null)")))).matches("VALUES ROW(null, null)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES (null, null), ('a', 'b')")))).matches("VALUES ROW(null, null), ROW('a', 'b')");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("VALUES CAST(ROW(null, null) AS row(real, double)), (1, 1)")))).matches("VALUES ROW(null, null), ROW(REAL '1', DOUBLE '1')");
    }

    @Test
    public void testFailingExpression() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("VALUES 0 / 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("VALUES CASE 1 WHEN 0 THEN true WHEN 0 / 0 THEN false END")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.query("VALUES IF(0 / 0 > 0, true, false)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }
}

