/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import io.trino.util.MoreMaps;
import io.trino.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestRowOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestRowOperators.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testRowTypeLookup() {
        TypeSignature signature = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"b", (Type)BigintType.BIGINT))).getTypeSignature();
        Type type = ((LocalQueryRunner)this.assertions.getQueryRunner()).getPlannerContext().getTypeManager().getType(signature);
        Assert.assertEquals((int)type.getTypeSignature().getParameters().size(), (int)1);
        Assert.assertEquals((String)((String)((TypeSignatureParameter)type.getTypeSignature().getParameters().get(0)).getNamedTypeSignature().getName().get()), (String)"b");
    }

    @Test
    public void testRowToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(null as ROW(BIGINT, VARCHAR))")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as json)").binding("a", "ROW(null, null)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":null,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(true, false, null)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":true,\"\":false,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ROW(12, 12345, 123456789, 1234567890123456789, null, null, null, null) as ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":12,\"\":12345,\"\":123456789,\"\":1234567890123456789,\"\":null,\"\":null,\"\":null,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(CAST(3.14E0 as REAL), 3.1415E0, 1e308, DECIMAL '3.14', DECIMAL '12345678901234567890.123456789012345678', CAST(null AS REAL), CAST(null AS DOUBLE), CAST(null AS DECIMAL))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":3.14,\"\":3.1415,\"\":1.0E308,\"\":3.14,\"\":12345678901234567890.123456789012345678,\"\":null,\"\":null,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW('a', 'bb', CAST(null as VARCHAR), JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', CAST(null AS JSON))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":\"a\",\"\":\"bb\",\"\":null,\"\":123,\"\":3.14,\"\":false,\"\":\"abc\",\"\":[1,\"a\",null],\"\":{\"a\":1,\"b\":\"str\",\"c\":null},\"\":null,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(DATE '2001-08-22', DATE '2001-08-23', null)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":\"2001-08-22\",\"\":\"2001-08-23\",\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(TIMESTAMP '1970-01-01 00:00:01', CAST(null as TIMESTAMP))")))).hasType((Type)JsonType.JSON).isEqualTo(String.format("{\"\":\"%s\",\"\":null}", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], CAST(null as ARRAY(BIGINT)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":[1,2],\"\":[3,null],\"\":[],\"\":[null,null],\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), CAST(NULL as MAP(VARCHAR, BIGINT)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":{\"a\":1,\"b\":2},\"\":{\"none\":null,\"three\":3},\"\":{},\"\":{\"h1\":null,\"h2\":null},\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":{\"\":1,\"\":2},\"\":{\"\":3,\"\":null},\"\":{\"\":null,\"\":null},\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(1, 2)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1,\"\":2}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "CAST(ROW(1, 2) as ROW(a BIGINT, b BIGINT))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"a\":1,\"b\":2}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(1, NULL)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS JSON)").binding("a", "ROW(1, CAST(NULL as INTEGER))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1,\"\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(1, 2.0E0)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1,\"\":2.0}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(1.0E0, 2.5E0)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1.0,\"\":2.5}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(1.0E0, 'kittens')")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1.0,\"\":\"kittens\"}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(TRUE, FALSE)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":true,\"\":false}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "ROW(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":false,\"\":[1,2],\"\":{\"1\":2.0,\"3\":4.0}}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as JSON)").binding("a", "row(1.0, 123123123456.6549876543)")))).hasType((Type)JsonType.JSON).isEqualTo("{\"\":1.0,\"\":123123123456.6549876543}");
    }

    @Test
    public void testJsonToRow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(BIGINT))").binding("a", "CAST(null as JSON)")))).isNull((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(BIGINT))").binding("a", "JSON 'null'")))).isNull((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(VARCHAR, BIGINT))").binding("a", "JSON '[null, null]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT))).isEqualTo(Lists.newArrayList((Object[])new Object[]{null, null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(k1 VARCHAR, k2 BIGINT))").binding("a", "JSON '{\"k2\": null, \"k1\": null}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT)))).isEqualTo(Lists.newArrayList((Object[])new Object[]{null, null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(used BIGINT))").binding("a", "JSON '{\"k1\": [1, 2], \"used\": 3, \"k2\": [4, 5]}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"used", (Type)BigintType.BIGINT)))).isEqualTo(ImmutableList.of((Object)3L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ARRAY(ROW(used BIGINT)))").binding("a", "JSON '[{\"k1\": [1, 2], \"used\": 3, \"k2\": [4, 5]}]'")))).hasType((Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"used", (Type)BigintType.BIGINT))))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)3L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(a BIGINT, b BIGINT, c BIGINT, d BIGINT))").binding("a", "JSON '{\"a\":1,\"c\":3}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"c", (Type)BigintType.BIGINT), (Object)RowType.field((String)"d", (Type)BigintType.BIGINT)))).isEqualTo(Arrays.asList(1L, null, 3L, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ARRAY(ROW(a BIGINT, b BIGINT, c BIGINT, d BIGINT)))").binding("a", "JSON '[{\"a\":1,\"c\":3}]'")))).hasType((Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"c", (Type)BigintType.BIGINT), (Object)RowType.field((String)"d", (Type)BigintType.BIGINT))))).isEqualTo(ImmutableList.of(Arrays.asList(1L, null, 3L, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(k1 BIGINT, k2 BIGINT, k3 BIGINT, k4 BIGINT))").binding("a", "unchecked_to_json('{\"k4\": 4, \"k2\": 2, \"k3\": 3, \"k1\": 1}')")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k3", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k4", (Type)BigintType.BIGINT)))).isEqualTo(ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ARRAY(ROW(k1 BIGINT, k2 BIGINT, k3 BIGINT, k4 BIGINT)))").binding("a", "unchecked_to_json('[{\"k4\": 4, \"k2\": 2, \"k3\": 3, \"k1\": 1}]')")))).hasType((Type)new ArrayType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k3", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k4", (Type)BigintType.BIGINT))))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN, BOOLEAN))").binding("a", "JSON '[true, false, 12, 0, 12.3, 0.0, \"true\", \"false\", null]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN))).isEqualTo(Arrays.asList(true, false, true, false, true, false, true, false, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(k1 BOOLEAN, k2 BOOLEAN, k3 BOOLEAN, k4 BOOLEAN, k5 BOOLEAN, k6 BOOLEAN, k7 BOOLEAN, k8 BOOLEAN, k9 BOOLEAN))").binding("a", "JSON '{\"k1\": true, \"k2\": false, \"k3\": 12, \"k4\": 0, \"k5\": 12.3, \"k6\": 0.0, \"k7\": \"true\", \"k8\": \"false\", \"k9\": null}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k2", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k3", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k4", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k5", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k6", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k7", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k8", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"k9", (Type)BooleanType.BOOLEAN)))).isEqualTo(Arrays.asList(true, false, true, false, true, false, true, false, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(TINYINT, SMALLINT, INTEGER, BIGINT, TINYINT, SMALLINT, INTEGER, BIGINT))").binding("a", "JSON '[12,12345,123456789,1234567890123456789,null,null,null,null]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT))).isEqualTo(Arrays.asList((byte)12, (short)12345, 123456789, 1234567890123456789L, null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(tinyint_value TINYINT, smallint_value SMALLINT, integer_value INTEGER, bigint_value BIGINT, tinyint_null TINYINT, smallint_null SMALLINT, integer_null INTEGER, bigint_null BIGINT))").binding("a", "JSON '{\"tinyint_value\": 12, \"tinyint_null\":null, \"smallint_value\":12345, \"smallint_null\":null,  \"integer_value\":123456789, \"integer_null\": null, \"bigint_value\":1234567890123456789, \"bigint_null\": null}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"tinyint_value", (Type)TinyintType.TINYINT), (Object)RowType.field((String)"smallint_value", (Type)SmallintType.SMALLINT), (Object)RowType.field((String)"integer_value", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"bigint_value", (Type)BigintType.BIGINT), (Object)RowType.field((String)"tinyint_null", (Type)TinyintType.TINYINT), (Object)RowType.field((String)"smallint_null", (Type)SmallintType.SMALLINT), (Object)RowType.field((String)"integer_null", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"bigint_null", (Type)BigintType.BIGINT)))).isEqualTo(Arrays.asList((byte)12, (short)12345, 123456789, 1234567890123456789L, null, null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(REAL, DOUBLE, DECIMAL(10, 5), DECIMAL(38, 8), REAL, DOUBLE, DECIMAL(7, 7)))").binding("a", "JSON '[12345.67,1234567890.1,123.456,12345678.12345678,null,null,null]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)DecimalType.createDecimalType((int)10, (int)5), (Object)DecimalType.createDecimalType((int)38, (int)8), (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)DecimalType.createDecimalType((int)7, (int)7)))).isEqualTo(Arrays.asList(Float.valueOf(12345.67f), 1.2345678901E9, SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"12345678.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(real_value REAL, double_value DOUBLE, decimal_value1 DECIMAL(10, 5), decimal_value2 DECIMAL(38, 8), real_null REAL, double_null DOUBLE, decimal_null DECIMAL(7, 7)))").binding("a", "JSON '{\"real_value\": 12345.67, \"real_null\": null, \"double_value\": 1234567890.1, \"double_null\": null, \"decimal_value1\": 123.456, \"decimal_value2\": 12345678.12345678, \"decimal_null\": null}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"real_value", (Type)RealType.REAL), (Object)RowType.field((String)"double_value", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"decimal_value1", (Type)DecimalType.createDecimalType((int)10, (int)5)), (Object)RowType.field((String)"decimal_value2", (Type)DecimalType.createDecimalType((int)38, (int)8)), (Object)RowType.field((String)"real_null", (Type)RealType.REAL), (Object)RowType.field((String)"double_null", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"decimal_null", (Type)DecimalType.createDecimalType((int)7, (int)7))))).isEqualTo(Arrays.asList(Float.valueOf(12345.67f), 1.2345678901E9, SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"12345678.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), null, null, null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as ROW(VARCHAR, JSON, VARCHAR, JSON))").binding("a", "JSON '[\"puppies\", [1, 2, 3], null, null]'")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)JsonType.JSON, (Object)VarcharType.VARCHAR, (Object)JsonType.JSON))).isEqualTo(Arrays.asList("puppies", "[1,2,3]", null, "null"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(varchar_value VARCHAR, json_value_field JSON, varchar_null VARCHAR, json_null JSON))").binding("a", "JSON '{\"varchar_value\": \"puppies\", \"json_value_field\": [1, 2, 3], \"varchar_null\": null, \"json_null\": null}'")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"varchar_value", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"json_value_field", (Type)JsonType.JSON), (Object)RowType.field((String)"varchar_null", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"json_null", (Type)JsonType.JSON)))).isEqualTo(Arrays.asList("puppies", "[1,2,3]", null, "null"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(ARRAY(BIGINT), ARRAY(BIGINT), ARRAY(BIGINT), MAP(VARCHAR, BIGINT), MAP(VARCHAR, BIGINT), MAP(VARCHAR, BIGINT), ROW(BIGINT, BIGINT, BIGINT, BIGINT), ROW(BIGINT),ROW(a BIGINT, b BIGINT, three BIGINT, none BIGINT), ROW(nothing BIGINT)))").binding("a", "JSON '[[1, 2, null, 3], [], null, {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, {}, null, [1, 2, null, 3], null, {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, null]' ")))).hasType((Type)RowType.anonymous((List)ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT), (Object)new ArrayType((Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), (Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)), (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"three", (Type)BigintType.BIGINT), (Object)RowType.field((String)"none", (Type)BigintType.BIGINT))), (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nothing", (Type)BigintType.BIGINT)))))).isEqualTo(Arrays.asList(Arrays.asList(1L, 2L, null, 3L), Collections.emptyList(), null, MoreMaps.asMap((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"none", (Object)"three"), Arrays.asList(1L, 2L, null, 3L)), ImmutableMap.of(), null, Arrays.asList(1L, 2L, null, 3L), null, Arrays.asList(1L, 2L, 3L, null), null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS ROW(array1 ARRAY(BIGINT), array2 ARRAY(BIGINT), array3 ARRAY(BIGINT), map1 MAP(VARCHAR, BIGINT), map2 MAP(VARCHAR, BIGINT), map3 MAP(VARCHAR, BIGINT), rowAsJsonArray1 ROW(BIGINT, BIGINT, BIGINT, BIGINT), rowAsJsonArray2 ROW(BIGINT),rowAsJsonObject1 ROW(nothing BIGINT), rowAsJsonObject2 ROW(a BIGINT, b BIGINT, three BIGINT, none BIGINT)))").binding("a", "JSON '{\"array2\": [1, 2, null, 3], \"array1\": [], \"array3\": null, \"map3\": {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, \"map1\": {}, \"map2\": null, \"rowAsJsonArray1\": [1, 2, null, 3], \"rowAsJsonArray2\": null, \"rowAsJsonObject2\": {\"a\": 1, \"b\": 2, \"none\": null, \"three\": 3}, \"rowAsJsonObject1\": null}' ")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"array1", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array2", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"array3", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"map1", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map2", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"map3", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"rowasjsonarray1", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT))), (Object)RowType.field((String)"rowasjsonarray2", (Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))), (Object)RowType.field((String)"rowasjsonobject1", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nothing", (Type)BigintType.BIGINT)))), (Object)RowType.field((String)"rowasjsonobject2", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)BigintType.BIGINT), (Object)RowType.field((String)"three", (Type)BigintType.BIGINT), (Object)RowType.field((String)"none", (Type)BigintType.BIGINT))))))).isEqualTo(Arrays.asList(Collections.emptyList(), Arrays.asList(1L, 2L, null, 3L), null, ImmutableMap.of(), null, MoreMaps.asMap((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"none", (Object)"three"), Arrays.asList(1L, 2L, null, 3L)), Arrays.asList(1L, 2L, null, 3L), null, null, Arrays.asList(1L, 2L, 3L, null)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a as ROW(a BIGINT, b BIGINT))").binding("a", "unchecked_to_json('{\"a\":1,\"b\":2,\"a\":3}')").evaluate()).hasMessage("Cannot cast to row(a bigint, b bigint). Duplicate field: a\n{\"a\":1,\"b\":2,\"a\":3}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(a as ARRAY(ROW(a BIGINT, b BIGINT)))").binding("a", "unchecked_to_json('[{\"a\":1,\"b\":2,\"a\":3}]')").evaluate()).hasMessage("Cannot cast to array(row(a bigint, b bigint)). Duplicate field: a\n[{\"a\":1,\"b\":2,\"a\":3}]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testFieldAccessor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(1, CAST(NULL AS DOUBLE))")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(TRUE, CAST(NULL AS BOOLEAN))")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(TRUE, CAST(NULL AS ARRAY(INTEGER)))")))).isNull((Type)new ArrayType((Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(1.0E0, CAST(NULL AS VARCHAR))")))).isNull((Type)VarcharType.createUnboundedVarcharType());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "row(1, 2)")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(1, 'kittens')")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(1, 2)")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "row(FALSE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)1, (Object)2.0, (Object)3, (Object)4.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2][2][1]").binding("a", "row(1.0E0, ARRAY[row(31, 4.1E0), row(32, 4.2E0)], row(3, 4.0E0))")))).isEqualTo(32);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "cast(ROW(1, 2) AS ROW(a BIGINT, b DOUBLE))")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "cast(ROW(1, 2) AS ROW(a BIGINT, b DOUBLE))")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1][1]").binding("a", "row(row('aa'))")))).hasType((Type)VarcharType.createVarcharType((int)2)).isEqualTo("aa");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1][1]").binding("a", "row(row('ab'))")))).hasType((Type)VarcharType.createVarcharType((int)2)).isEqualTo("ab");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "cast(ROW(ARRAY[NULL]) AS ROW(a ARRAY(BIGINT)))")))).hasType((Type)new ArrayType((Type)BigintType.BIGINT)).isEqualTo(Arrays.asList(new Integer[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "cast(row(1.0, 123123123456.6549876543) AS ROW(col0 decimal(2,1), col1 decimal(22,10)))")))).isEqualTo(SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[2]").binding("a", "cast(row(1.0, 123123123456.6549876543) AS ROW(col0 decimal(2,1), col1 decimal(22,10)))")))).isEqualTo(SqlDecimal.decimal((String)"123123123456.6549876543", (DecimalType)DecimalType.createDecimalType((int)22, (int)10)));
    }

    @Test
    public void testRowCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb bigint))[1]").binding("a", "row(2, 3)")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb bigint))[2]").binding("a", "row(2, 3)")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb boolean))[2]").binding("a", "row(2, 3)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb double))[2]").binding("a", "row(2, CAST(null as double))")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb varchar))[2]").binding("a", "row(2, 'test_str')")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("test_str");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb boolean, cc boolean))[2]").binding("a", "row(1,null,3)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb boolean, cc boolean))[1]").binding("a", "row(1,null,3)")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS row(aa bigint, bb boolean, cc boolean))[1]").binding("a", "row(null,null,null)")))).isNull((Type)BigintType.BIGINT);
        String longFieldNameCast = "CAST(a AS ROW(%s VARCHAR, %s ARRAY(ROW(%s VARCHAR, %s VARCHAR)), %s ROW(%s VARCHAR, %s VARCHAR)))[2][1][1]";
        int fieldCount = 7;
        char[] chars = new char[9333];
        String[] fields = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            Arrays.fill(chars, (char)(97 + i));
            fields[i] = new String(chars);
        }
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression(String.format(longFieldNameCast, fields[0], fields[1], fields[2], fields[3], fields[4], fields[5], fields[6])).binding("a", "row(1.2E0, ARRAY[row(233, 6.9E0)], row(1000, 6.3E0))")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("233");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a as row(a BIGINT, b DOUBLE, c BOOLEAN, d VARCHAR, e ARRAY(BIGINT)))").binding("a", "row(json '2', json '1.5', json 'true', json '\"abc\"', json '[1, 2]')")))).hasType((Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)DoubleType.DOUBLE), (Object)RowType.field((String)"c", (Type)BooleanType.BOOLEAN), (Object)RowType.field((String)"d", (Type)VarcharType.VARCHAR), (Object)RowType.field((String)"e", (Type)new ArrayType((Type)BigintType.BIGINT))))).isEqualTo(Arrays.asList(2L, 1.5, true, "abc", ImmutableList.of((Object)1L, (Object)2L)));
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS ROW(UNKNOWN))", "CAST(NULL AS ROW(UNKNOWN))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(NULL)", "row(NULL)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 'cat')", "row(1, 'cat')")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, ARRAY [1])", "row(1, ARRAY [1])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, ARRAY [1, 2])", "row(1, ARRAY [1, NULL])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, 'cat', from_unixtime(1))", "row(1, 2.0E0, TRUE, 'cat', from_unixtime(1))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, 'cat', from_unixtime(1))", "row(1, 2.0E0, TRUE, 'cat', from_unixtime(2))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER))", "row(1, 2.0E0, TRUE, 'cat', 2)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER))", "row(1, 2.0E0, TRUE, 'cat', CAST(NULL AS INTEGER))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, 'cat')", "row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3)))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3)))", "row(1, 2.0E0, TRUE, CAST(NULL AS VARCHAR(3)))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "ARRAY[ROW(1)]", "ARRAY[ROW(1)]")))).isEqualTo(false);
    }

    @Test
    public void testRowComparison() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(TIMESTAMP '2002-01-02 03:04:05.321 +08:10', TIMESTAMP '2002-01-02 03:04:05.321 +08:10')", "row(TIMESTAMP '2002-01-02 02:04:05.321 +07:10', TIMESTAMP '2002-01-02 03:05:05.321 +08:11')")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))", "row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:11'))")))).isEqualTo(false);
        this.assertComparisonCombination("row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10')", "row(TIMESTAMP '2002-01-02 03:04:05.321 +07:09', TIMESTAMP '2002-01-02 03:04:05.321 +07:09')");
        this.assertComparisonCombination("row(1.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))", "row(2.0E0, row(TIMESTAMP '2001-01-02 03:04:05.321 +07:09', TIMESTAMP '2001-01-02 03:04:05.321 +07:10'))");
        this.assertComparisonCombination("row(1.0E0, 'kittens')", "row(1.0E0, 'puppies')");
        this.assertComparisonCombination("row(1, 2.0E0)", "row(5, 2.0E0)");
        this.assertComparisonCombination("row(TRUE, FALSE, TRUE, FALSE)", "row(TRUE, TRUE, TRUE, FALSE)");
        this.assertComparisonCombination("row(1, 2.0E0, TRUE, 'kittens', from_unixtime(1))", "row(1, 3.0E0, TRUE, 'kittens', from_unixtime(1))");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(row(CAST(CAST('' as varbinary) as hyperloglog)) as row(col0 hyperloglog)) = CAST(row(CAST(CAST('' as varbinary) as hyperloglog)) as row(col0 hyperloglog))").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:91: Cannot apply operator: row(col0 HyperLogLog) = row(col0 HyperLogLog)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(row(CAST(CAST('' as varbinary) as hyperloglog)) as row(col0 hyperloglog)) > CAST(row(CAST(CAST('' as varbinary) as hyperloglog)) as row(col0 hyperloglog))").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:91: Cannot apply operator: row(col0 HyperLogLog) < row(col0 HyperLogLog)");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(row(CAST(CAST('' as varbinary) as qdigest(double))) as row(col0 qdigest(double))) = CAST(row(CAST(CAST('' as varbinary) as qdigest(double))) as row(col0 qdigest(double)))").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:99: Cannot apply operator: row(col0 qdigest(double)) = row(col0 qdigest(double))");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("CAST(row(CAST(CAST('' as varbinary) as qdigest(double))) as row(col0 qdigest(double))) > CAST(row(CAST(CAST('' as varbinary) as qdigest(double))) as row(col0 qdigest(double)))").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:99: Cannot apply operator: row(col0 qdigest(double)) < row(col0 qdigest(double))");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(TRUE, ARRAY [1], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))", "row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))", "row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(1, CAST(NULL AS INTEGER))", "row(1, 2)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "row(1, CAST(NULL AS INTEGER))").binding("b", "row(1, 2)")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "row(2, CAST(NULL AS INTEGER))", "row(1, 2)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "row(2, CAST(NULL AS INTEGER))").binding("b", "row(1, 2)")))).isEqualTo(true);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])) > row(TRUE, ARRAY [1, 2], MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0]))").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:75: Cannot apply operator: row(boolean, array(integer), map(integer, double)) < row(boolean, array(integer), map(integer, double))");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("row(1, CAST(NULL AS INTEGER)) < row(1, 2)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        this.assertComparisonCombination("row(1.0E0, ARRAY [1,2,3], row(2, 2.0E0))", "row(1.0E0, ARRAY [1,3,3], row(2, 2.0E0))");
        this.assertComparisonCombination("row(TRUE, ARRAY [1])", "row(TRUE, ARRAY [1, 2])");
        this.assertComparisonCombination("ROW(1, 2)", "ROW(2, 1)");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "ROW(1, 2)", "ROW(1, 2)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ROW(2, 1)").binding("b", "ROW(1, 2)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "ROW(1.0, 123123123456.6549876543)", "ROW(1.0, 123123123456.6549876543)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "ROW(1.0, 123123123456.6549876543)", "ROW(1.0, 123123123456.6549876542)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ROW(1.0, 123123123456.6549876543)").binding("b", "ROW(1.0, 123123123456.6549876543)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "ROW(1.0, 123123123456.6549876543)").binding("b", "ROW(1.0, 123123123456.6549876542)")))).isEqualTo(true);
        for (int i = 1; i < 128; i += 10) {
            this.assertEqualOperator(i);
        }
    }

    @Test
    public void testRowHashOperator() {
        this.assertRowHashOperator("ROW(1, 2)", (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (List<Object>)ImmutableList.of((Object)1, (Object)2));
        this.assertRowHashOperator("ROW(true, 2)", (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER), (List<Object>)ImmutableList.of((Object)true, (Object)2));
        for (int i = 1; i < 128; i += 5) {
            this.assertRowHashOperator(i, false);
            this.assertRowHashOperator(i, true);
        }
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(null as row(col0 bigint))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(1)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(null)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(1,2)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(1,null)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(null,2)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(null,null)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row('111',null)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(null,'222')")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row('111','222')")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1), row(2), row(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1), row(null), row(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1), row(CAST(null as bigint)), row(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(row(1)), row(2), row(3))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(row(null)), row(2), row(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(row(CAST(null as boolean))), row(2), row(3))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[3,4,5]))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(3,4)]))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(null,2),row(array[row(3,4)]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,null),row(array[row(3,4)]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[CAST(row(3,4) as row(a integer, b integer)), CAST(null as row(a integer, b integer))]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(null,4)]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(map(array[8], array[9]),4)]))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(row(1,2),row(array[row(map(array[8], array[null]),4)]))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(1E0,2E0)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(1E0,null)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(true,false)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "row(true,null)")))).isEqualTo(true);
    }

    private void assertEqualOperator(int fieldCount) {
        String rowLiteral = TestRowOperators.toRowLiteral(TestRowOperators.largeRow(fieldCount, false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", rowLiteral).binding("b", rowLiteral)))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", rowLiteral).binding("b", rowLiteral)))).isEqualTo(false);
        String alternateRowLiteral = TestRowOperators.toRowLiteral(TestRowOperators.largeRow(fieldCount, false, true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", rowLiteral).binding("b", alternateRowLiteral)))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", rowLiteral).binding("b", alternateRowLiteral)))).isEqualTo(true);
        if (fieldCount > 1) {
            String rowLiteralWithNulls = TestRowOperators.toRowLiteral(TestRowOperators.largeRow(fieldCount, true));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", rowLiteralWithNulls).binding("b", rowLiteralWithNulls)))).isNull((Type)BooleanType.BOOLEAN);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", rowLiteralWithNulls).binding("b", rowLiteralWithNulls)))).isNull((Type)BooleanType.BOOLEAN);
            String alternateRowLiteralWithNulls = TestRowOperators.toRowLiteral(TestRowOperators.largeRow(fieldCount, true, true));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a = b").binding("a", rowLiteralWithNulls).binding("b", alternateRowLiteralWithNulls)))).isEqualTo(false);
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", rowLiteralWithNulls).binding("b", alternateRowLiteralWithNulls)))).isEqualTo(true);
        }
    }

    private void assertRowHashOperator(int fieldCount, boolean nulls) {
        List<Object> data = TestRowOperators.largeRow(fieldCount, nulls);
        this.assertRowHashOperator(TestRowOperators.toRowLiteral(data), TestRowOperators.largeRowDataTypes(fieldCount), data);
    }

    private static String toRowLiteral(List<Object> data) {
        return "ROW(" + Joiner.on((String)", ").useForNull("null").join(data) + ")";
    }

    private void assertRowHashOperator(String inputString, List<Type> types, List<Object> elements) {
        Preconditions.checkArgument((types.size() == elements.size() ? 1 : 0) != 0, (Object)"types and elements must have the same size");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, inputString)))).isEqualTo(this.hashFields(types, elements));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, inputString)))).isEqualTo(this.hashFields(types, elements));
    }

    private long hashFields(List<Type> types, List<Object> elements) {
        Preconditions.checkArgument((types.size() == elements.size() ? 1 : 0) != 0, (Object)"types and elements must have the same size");
        long result = 1L;
        for (int i = 0; i < types.size(); ++i) {
            Object fieldValue = elements.get(i);
            long fieldHashCode = 0L;
            if (fieldValue != null) {
                Type fieldType = types.get(i);
                try {
                    fieldHashCode = ((LocalQueryRunner)this.assertions.getQueryRunner()).getTypeOperators().getHashCodeOperator(fieldType, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL})).invoke(fieldValue);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            result = CombineHashFunction.getHash((long)result, (long)fieldHashCode);
        }
        return result;
    }

    private static List<Object> largeRow(int fieldCount, boolean nulls) {
        return TestRowOperators.largeRow(fieldCount, nulls, false);
    }

    private static List<Object> largeRow(int fieldCount, boolean nulls, boolean alternateLastElement) {
        ArrayList<Object> data = new ArrayList<Object>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            if (nulls && i % 7 == 0) {
                data.add(null);
                continue;
            }
            if (i % 10 == 0) {
                data.add(true);
                continue;
            }
            data.add(i);
        }
        if (alternateLastElement) {
            int lastPosition = fieldCount - 1;
            if (nulls && lastPosition % 7 == 0) {
                --lastPosition;
            }
            if (lastPosition % 10 == 0) {
                data.set(lastPosition, false);
            } else {
                data.set(lastPosition, -lastPosition);
            }
        }
        return data;
    }

    private static List<Type> largeRowDataTypes(int fieldCount) {
        ArrayList<Type> types = new ArrayList<Type>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            if (i % 10 == 0) {
                types.add((Type)BooleanType.BOOLEAN);
                continue;
            }
            types.add((Type)IntegerType.INTEGER);
        }
        return types;
    }

    private void assertComparisonCombination(String base, String greater) {
        HashSet equalOperators = new HashSet(ImmutableSet.of((Object)"=", (Object)">=", (Object)"<="));
        HashSet greaterOrInequalityOperators = new HashSet(ImmutableSet.of((Object)">=", (Object)">", (Object)"!="));
        HashSet lessOrInequalityOperators = new HashSet(ImmutableSet.of((Object)"<=", (Object)"<", (Object)"!="));
        for (String operator : ImmutableList.of((Object)">", (Object)"=", (Object)"<", (Object)">=", (Object)"<=", (Object)"!=")) {
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a %s b".formatted(operator)).binding("a", base).binding("b", base)))).isEqualTo(equalOperators.contains(operator));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a %s b".formatted(operator)).binding("a", base).binding("b", greater)))).isEqualTo(lessOrInequalityOperators.contains(operator));
            ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a %s b".formatted(operator)).binding("a", greater).binding("b", base)))).isEqualTo(greaterOrInequalityOperators.contains(operator));
        }
    }
}

