/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestShortTimestampType
extends AbstractTestType {
    public TestShortTimestampType() {
        super((Type)TimestampType.TIMESTAMP_MILLIS, SqlTimestamp.class, TestShortTimestampType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = TimestampType.TIMESTAMP_MILLIS.createBlockBuilder(null, 15);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 1111000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 1111000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 1111000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 2222000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 2222000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 2222000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 2222000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 2222000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 3333000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 3333000L);
        TimestampType.TIMESTAMP_MILLIS.writeLong(blockBuilder, 4444000L);
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1000L;
    }

    @Override
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)-9223372036854775000L);
        Assert.assertEquals((Object)range.getMax(), (Object)9223372036854775000L);
    }

    @Test(dataProvider="testRangeEveryPrecisionDataProvider")
    public void testRangeEveryPrecision(int precision, long expectedMin, long expectedMax) {
        Type.Range range = (Type.Range)TimestampType.createTimestampType((int)precision).getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)expectedMin);
        Assert.assertEquals((Object)range.getMax(), (Object)expectedMax);
    }

    @DataProvider
    public static Object[][] testRangeEveryPrecisionDataProvider() {
        return new Object[][]{{0, -9223372036854000000L, 9223372036854000000L}, {1, -9223372036854700000L, 9223372036854700000L}, {2, -9223372036854770000L, 9223372036854770000L}, {3, -9223372036854775000L, 9223372036854775000L}, {4, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L}, {5, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L}, {6, Long.MIN_VALUE, Long.MAX_VALUE}};
    }

    @Override
    public void testPreviousValue() {
        long minValue = -9223372036854775000L;
        long maxValue = 9223372036854775000L;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1000L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(1110000L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1000L))).isEqualTo(Optional.of(maxValue - 2000L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1000L));
    }

    @Override
    public void testNextValue() {
        long minValue = -9223372036854775000L;
        long maxValue = 9223372036854775000L;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1000L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1000L))).isEqualTo(Optional.of(minValue + 2000L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(1112000L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1000L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }

    @Test(dataProvider="testPreviousNextValueEveryPrecisionDatProvider")
    public void testPreviousValueEveryPrecision(int precision, long minValue, long maxValue, long step) {
        TimestampType type = TimestampType.createTimestampType((int)precision);
        Assertions.assertThat((Optional)type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)type.getPreviousValue((Object)(minValue + step))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)0L)).isEqualTo(Optional.of(-step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)123456789000000L)).isEqualTo(Optional.of(123456789000000L - step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)(maxValue - step))).isEqualTo(Optional.of(maxValue - 2L * step));
        Assertions.assertThat((Optional)type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - step));
    }

    @Test(dataProvider="testPreviousNextValueEveryPrecisionDatProvider")
    public void testNextValueEveryPrecision(int precision, long minValue, long maxValue, long step) {
        TimestampType type = TimestampType.createTimestampType((int)precision);
        Assertions.assertThat((Optional)type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + step));
        Assertions.assertThat((Optional)type.getNextValue((Object)(minValue + step))).isEqualTo(Optional.of(minValue + 2L * step));
        Assertions.assertThat((Optional)type.getNextValue((Object)0L)).isEqualTo(Optional.of(step));
        Assertions.assertThat((Optional)type.getNextValue((Object)123456789000000L)).isEqualTo(Optional.of(123456789000000L + step));
        Assertions.assertThat((Optional)type.getNextValue((Object)(maxValue - step))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }

    @DataProvider
    public Object[][] testPreviousNextValueEveryPrecisionDatProvider() {
        return new Object[][]{{0, -9223372036854000000L, 9223372036854000000L, 1000000L}, {1, -9223372036854700000L, 9223372036854700000L, 100000L}, {2, -9223372036854770000L, 9223372036854770000L, 10000L}, {3, -9223372036854775000L, 9223372036854775000L, 1000L}, {4, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L, 100L}, {5, -9223372036854775800L, 0x7FFFFFFFFFFFFFF8L, 10L}, {6, Long.MIN_VALUE, Long.MAX_VALUE, 1L}};
    }
}

