/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.jmh.Benchmarks;
import io.trino.util.DateTimeUtils;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.Throughput})
@Fork(value=1)
@Warmup(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1000, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkParseDate {
    @Benchmark
    public void parseDate(BenchmarkData data, Blackhole blackhole) {
        for (String dt : data.dates) {
            blackhole.consume(DateTimeUtils.parseDate((String)dt));
        }
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkParseDate.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        String[] dates;

        @Setup
        public void setup() {
            this.dates = new String[100];
            String startDate = "2023-01-01";
            int days = DateTimeUtils.parseDate((String)startDate);
            for (int i = 0; i < this.dates.length; ++i) {
                this.dates[i] = DateTimeUtils.printDate((int)(days + i));
            }
        }
    }
}

