/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableSet;
import io.trino.connector.system.GlobalSystemTransactionHandle;
import io.trino.operator.table.Sequence;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.InternalConnector;
import io.trino.transaction.TransactionId;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class GlobalSystemConnector
implements InternalConnector {
    public static final String NAME = "system";
    public static final CatalogHandle CATALOG_HANDLE = CatalogHandle.createRootCatalogHandle((String)"system", (CatalogHandle.CatalogVersion)new CatalogHandle.CatalogVersion("system"));
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;
    private final Set<ConnectorTableFunction> tableFunctions;

    @Inject
    public GlobalSystemConnector(Set<SystemTable> systemTables, Set<Procedure> procedures, Set<ConnectorTableFunction> tableFunctions) {
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.tableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tableFunctions, "tableFunctions is null"));
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new GlobalSystemTransactionHandle(transactionId);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return new ConnectorMetadata(){};
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.tableFunctions;
    }

    public ConnectorSplitManager getSplitManager() {
        return new ConnectorSplitManager(){

            public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle functionHandle) {
                if (functionHandle instanceof Sequence.SequenceFunctionHandle) {
                    Sequence.SequenceFunctionHandle sequenceFunctionHandle = (Sequence.SequenceFunctionHandle)functionHandle;
                    return Sequence.getSequenceFunctionSplitSource(sequenceFunctionHandle);
                }
                throw new UnsupportedOperationException();
            }
        };
    }
}

