/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.RuleStats;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class RuleStatsSystemTable
implements SystemTable {
    private static final SchemaTableName TABLE_NAME = new SchemaTableName("runtime", "optimizer_rule_stats");
    private final ConnectorTableMetadata ruleStatsTable;
    private final Optional<RuleStatsRecorder> ruleStatsRecorder;

    @Inject
    public RuleStatsSystemTable(Optional<RuleStatsRecorder> ruleStatsRecorder, TypeManager typeManager) {
        this.ruleStatsRecorder = Objects.requireNonNull(ruleStatsRecorder, "ruleStatsRecorder is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.ruleStatsTable = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_NAME).column("rule_name", (Type)VarcharType.VARCHAR).column("invocations", (Type)BigintType.BIGINT).column("matches", (Type)BigintType.BIGINT).column("failures", (Type)BigintType.BIGINT).column("average_time", (Type)DoubleType.DOUBLE).column("time_distribution_percentiles", typeManager.getType(TypeSignature.mapType((TypeSignature)DoubleType.DOUBLE.getTypeSignature(), (TypeSignature)DoubleType.DOUBLE.getTypeSignature()))).build();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.ruleStatsTable;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        Preconditions.checkState((boolean)this.ruleStatsRecorder.isPresent(), (Object)"Rule stats system table can return results only on coordinator");
        Map<Class<?>, RuleStats> ruleStats = this.ruleStatsRecorder.get().getStats();
        int positionCount = ruleStats.size();
        Map blockBuilders = (Map)this.ruleStatsTable.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> column.getType().createBlockBuilder(null, positionCount)));
        for (Map.Entry<Class<?>, RuleStats> entry : ruleStats.entrySet()) {
            RuleStats stats = entry.getValue();
            VarcharType.VARCHAR.writeString((BlockBuilder)blockBuilders.get("rule_name"), entry.getKey().getSimpleName());
            BigintType.BIGINT.writeLong((BlockBuilder)blockBuilders.get("invocations"), stats.getInvocations());
            BigintType.BIGINT.writeLong((BlockBuilder)blockBuilders.get("matches"), stats.getHits());
            BigintType.BIGINT.writeLong((BlockBuilder)blockBuilders.get("failures"), stats.getFailures());
            DoubleType.DOUBLE.writeDouble((BlockBuilder)blockBuilders.get("average_time"), stats.getTime().getAvg());
            BlockBuilder mapWriter = ((BlockBuilder)blockBuilders.get("time_distribution_percentiles")).beginBlockEntry();
            for (Map.Entry percentile : stats.getTime().getPercentiles().entrySet()) {
                DoubleType.DOUBLE.writeDouble(mapWriter, ((Double)percentile.getKey()).doubleValue());
                DoubleType.DOUBLE.writeDouble(mapWriter, ((Double)percentile.getValue()).doubleValue());
            }
            ((BlockBuilder)blockBuilders.get("time_distribution_percentiles")).closeEntry();
        }
        Block[] blocks = (Block[])this.ruleStatsTable.getColumns().stream().map(column -> ((BlockBuilder)blockBuilders.get(column.getName())).build()).toArray(Block[]::new);
        return new FixedPageSource((List)ImmutableList.of((Object)new Page(positionCount, blocks)));
    }
}

