/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class DropCatalogTask
implements DataDefinitionTask<DropCatalog> {
    private final CatalogManager catalogManager;
    private final AccessControl accessControl;

    @Inject
    public DropCatalogTask(CatalogManager catalogManager, AccessControl accessControl) {
        this.catalogManager = Objects.requireNonNull(catalogManager, "catalogManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP CATALOG";
    }

    @Override
    public ListenableFuture<Void> execute(DropCatalog statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        if (statement.isCascade()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CASCADE is not yet supported for DROP SCHEMA");
        }
        this.accessControl.checkCanDropCatalog(stateMachine.getSession().toSecurityContext(), statement.getCatalogName().toString());
        this.catalogManager.dropCatalog(statement.getCatalogName().toString(), statement.isExists());
        return Futures.immediateVoidFuture();
    }
}

