/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.TruncateTable;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class TruncateTableTask
implements DataDefinitionTask<TruncateTable> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public TruncateTableTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "TRUNCATE TABLE";
    }

    @Override
    public ListenableFuture<Void> execute(TruncateTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        if (this.metadata.isMaterializedView(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()))) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot truncate a materialized view", new Object[0]);
        }
        if (this.metadata.isView(session, tableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot truncate a view", new Object[0]);
        }
        TableHandle tableHandle = this.metadata.getTableHandle(session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", tableName));
        this.accessControl.checkCanTruncateTable(session.toSecurityContext(), tableName);
        this.metadata.truncateTable(session, tableHandle);
        return Futures.immediateFuture(null);
    }
}

