/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableSet;
import io.trino.client.NodeVersion;
import io.trino.metadata.AllNodes;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.spi.connector.CatalogHandle;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryNodeManager
implements InternalNodeManager {
    private static final InternalNode CURRENT_NODE = new InternalNode("local", URI.create("local://127.0.0.1:8080"), NodeVersion.UNKNOWN, true);
    private final Set<InternalNode> allNodes = ConcurrentHashMap.newKeySet();

    public InMemoryNodeManager(InternalNode ... remoteNodes) {
        this((Set<InternalNode>)ImmutableSet.copyOf((Object[])remoteNodes));
    }

    public InMemoryNodeManager(Set<InternalNode> remoteNodes) {
        this.allNodes.add(CURRENT_NODE);
        this.allNodes.addAll(remoteNodes);
    }

    public void addNodes(InternalNode ... internalNodes) {
        for (InternalNode internalNode : internalNodes) {
            this.allNodes.add(Objects.requireNonNull(internalNode, "internalNode is null"));
        }
    }

    public void removeNode(InternalNode internalNode) {
        this.allNodes.remove(internalNode);
    }

    @Override
    public Set<InternalNode> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return ImmutableSet.copyOf(this.allNodes);
            }
            case INACTIVE: 
            case SHUTTING_DOWN: {
                return ImmutableSet.of();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + state);
    }

    @Override
    public Set<InternalNode> getActiveCatalogNodes(CatalogHandle catalogHandle) {
        return ImmutableSet.copyOf(this.allNodes);
    }

    @Override
    public InternalNodeManager.NodesSnapshot getActiveNodesSnapshot() {
        return new InternalNodeManager.NodesSnapshot((Set<InternalNode>)ImmutableSet.copyOf(this.allNodes), Optional.empty());
    }

    @Override
    public AllNodes getAllNodes() {
        return new AllNodes((Set<InternalNode>)ImmutableSet.copyOf(this.allNodes), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of(), (Set<InternalNode>)ImmutableSet.of((Object)CURRENT_NODE));
    }

    @Override
    public InternalNode getCurrentNode() {
        return CURRENT_NODE;
    }

    @Override
    public Set<InternalNode> getCoordinators() {
        return ImmutableSet.of((Object)CURRENT_NODE);
    }

    @Override
    public void refreshNodes() {
    }

    @Override
    public void addNodeChangeListener(Consumer<AllNodes> listener) {
    }

    @Override
    public void removeNodeChangeListener(Consumer<AllNodes> listener) {
    }
}

