/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.GroupByHash;
import io.trino.operator.OperatorContext;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;
    private final int[] hashChannels;

    public ChannelSet(GroupByHash hash, boolean containsNull, int[] hashChannels) {
        this.hash = hash;
        this.containsNull = containsNull;
        this.hashChannels = hashChannels;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Page page) {
        return this.hash.contains(position, page, this.hashChannels);
    }

    public boolean contains(int position, Page page, long rawHash) {
        return this.hash.contains(position, page, this.hashChannels, rawHash);
    }

    public static class ChannelSetBuilder {
        private static final int[] HASH_CHANNELS = new int[]{0};
        private final GroupByHash hash;
        private final Page nullBlockPage;
        private final OperatorContext operatorContext;
        private final LocalMemoryContext localMemoryContext;

        public ChannelSetBuilder(Type type, Optional<Integer> hashChannel, int expectedPositions, OperatorContext operatorContext, JoinCompiler joinCompiler, BlockTypeOperators blockTypeOperators) {
            ImmutableList types = ImmutableList.of((Object)type);
            this.hash = GroupByHash.createGroupByHash(operatorContext.getSession(), (List<? extends Type>)types, HASH_CHANNELS, hashChannel, expectedPositions, joinCompiler, blockTypeOperators, this::updateMemoryReservation);
            this.nullBlockPage = new Page(new Block[]{type.createBlockBuilder(null, 1, UnknownType.UNKNOWN.getFixedSize()).appendNull().build()});
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.localMemoryContext = operatorContext.localUserMemoryContext();
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlockPage, HASH_CHANNELS), HASH_CHANNELS);
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public Work<?> addPage(Page page) {
            return this.hash.addPage(page);
        }

        public boolean updateMemoryReservation() {
            this.localMemoryContext.setBytes(this.hash.getEstimatedSize());
            return this.operatorContext.isWaitingForMemory().isDone();
        }

        @VisibleForTesting
        public int getCapacity() {
            return this.hash.getCapacity();
        }
    }
}

