/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.operator.IncrementalLoadFactorHashArraySizeSupplier;
import it.unimi.dsi.fastutil.HashCommon;

public interface HashArraySizeSupplier {
    public static HashArraySizeSupplier defaultHashArraySizeSupplier() {
        return expectedCount -> HashCommon.arraySize((int)expectedCount, (float)0.75f);
    }

    public static HashArraySizeSupplier incrementalLoadFactorHashArraySizeSupplier(Session session) {
        return HashArraySizeSupplier.incrementalLoadFactorHashArraySizeSupplier(session, 1);
    }

    public static HashArraySizeSupplier incrementalLoadFactorHashArraySizeSupplier(Session session, int multiplier) {
        if (SystemSessionProperties.isIncrementalHashArrayLoadFactorEnabled(session)) {
            return new IncrementalLoadFactorHashArraySizeSupplier(multiplier);
        }
        return HashArraySizeSupplier.defaultHashArraySizeSupplier();
    }

    public int getHashArraySize(int var1);
}

