/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join.unspilled;

import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import io.trino.operator.join.LookupSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final Page page;
    private final long[] joinPositionCache;
    private final boolean isRle;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, Page probePage, LookupSource lookupSource, @Nullable Block probeHashBlock, boolean hasFilter) {
        this.probeOutputChannels = Objects.requireNonNull(probeOutputChannels, "probeOutputChannels is null");
        this.page = Objects.requireNonNull(page, "page is null");
        this.isRle = !hasFilter && JoinProbe.hasOnlyRleBlocks(probePage);
        this.joinPositionCache = JoinProbe.fillCache(lookupSource, page, probeHashBlock, probePage, this.isRle);
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        Verify.verify((++this.position <= this.page.getPositionCount() ? 1 : 0) != 0, (String)"already finished", (Object[])new Object[0]);
        return !this.isFinished();
    }

    public void finish() {
        this.position = this.page.getPositionCount();
    }

    public boolean isFinished() {
        return this.position == this.page.getPositionCount();
    }

    public long getCurrentJoinPosition() {
        return this.joinPositionCache[this.position];
    }

    public int getPosition() {
        return this.position;
    }

    public boolean areProbeJoinChannelsRunLengthEncoded() {
        return this.isRle;
    }

    public Page getPage() {
        return this.page;
    }

    private static long[] fillCache(LookupSource lookupSource, Page page, Block probeHashBlock, Page probePage, boolean isRle) {
        int positionCount = page.getPositionCount();
        Block[] nullableBlocks = new Block[probePage.getChannelCount()];
        int nullableBlocksCount = 0;
        for (int channel = 0; channel < probePage.getChannelCount(); ++channel) {
            Block probeBlock = probePage.getBlock(channel);
            if (!probeBlock.mayHaveNull()) continue;
            nullableBlocks[nullableBlocksCount++] = probeBlock;
        }
        if (isRle) {
            long[] joinPositionCache;
            boolean anyAllNullsBlock = false;
            for (int i = 0; i < nullableBlocksCount; ++i) {
                Block nullableBlock = nullableBlocks[i];
                if (!nullableBlock.isNull(0)) continue;
                anyAllNullsBlock = true;
                break;
            }
            if (anyAllNullsBlock) {
                joinPositionCache = new long[]{-1L};
            } else {
                joinPositionCache = new long[positionCount];
                Arrays.fill(joinPositionCache, lookupSource.getJoinPosition(0, probePage, page));
            }
            return joinPositionCache;
        }
        long[] joinPositionCache = new long[positionCount];
        if (nullableBlocksCount > 0) {
            Arrays.fill(joinPositionCache, -1L);
            boolean[] isNull = new boolean[positionCount];
            int nonNullCount = JoinProbe.getIsNull(nullableBlocks, nullableBlocksCount, positionCount, isNull);
            if (nonNullCount < positionCount) {
                int[] positions = new int[nonNullCount];
                nonNullCount = 0;
                for (int i = 0; i < positionCount; ++i) {
                    if (!isNull[i]) {
                        positions[nonNullCount] = i;
                    }
                    nonNullCount += isNull[i] ? 0 : 1;
                }
                if (probeHashBlock != null) {
                    long[] hashes = new long[positionCount];
                    for (int i = 0; i < positionCount; ++i) {
                        hashes[i] = BigintType.BIGINT.getLong(probeHashBlock, i);
                    }
                    lookupSource.getJoinPosition(positions, probePage, page, hashes, joinPositionCache);
                } else {
                    lookupSource.getJoinPosition(positions, probePage, page, joinPositionCache);
                }
                return joinPositionCache;
            }
        }
        int[] positions = new int[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            positions[i] = i;
        }
        if (probeHashBlock != null) {
            long[] hashes = new long[positionCount];
            for (int i = 0; i < positionCount; ++i) {
                hashes[i] = BigintType.BIGINT.getLong(probeHashBlock, i);
            }
            lookupSource.getJoinPosition(positions, probePage, page, hashes, joinPositionCache);
        } else {
            lookupSource.getJoinPosition(positions, probePage, page, joinPositionCache);
        }
        return joinPositionCache;
    }

    private static int getIsNull(Block[] nullableBlocks, int nullableBlocksCount, int positionCount, boolean[] isNull) {
        int position;
        for (int i = 0; i < nullableBlocksCount - 1; ++i) {
            Block block = nullableBlocks[i];
            for (position = 0; position < positionCount; ++position) {
                int n = position;
                isNull[n] = isNull[n] | block.isNull(position);
            }
        }
        int nonNullCount = 0;
        Block lastBlock = nullableBlocks[nullableBlocksCount - 1];
        for (position = 0; position < positionCount; ++position) {
            int n = position;
            isNull[n] = isNull[n] | lastBlock.isNull(position);
            nonNullCount += isNull[position] ? 0 : 1;
        }
        return nonNullCount;
    }

    private static boolean hasOnlyRleBlocks(Page probePage) {
        if (probePage.getChannelCount() == 0) {
            return false;
        }
        for (int i = 0; i < probePage.getChannelCount(); ++i) {
            if (probePage.getBlock(i) instanceof RunLengthEncodedBlock) continue;
            return false;
        }
        return true;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final int[] probeJoinChannels;
        private final int probeHashChannel;
        private final boolean hasFilter;

        public JoinProbeFactory(List<Integer> probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, boolean hasFilter) {
            this.probeOutputChannels = Ints.toArray((Collection)Objects.requireNonNull(probeOutputChannels, "probeOutputChannels is null"));
            this.probeJoinChannels = Ints.toArray((Collection)Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null"));
            this.probeHashChannel = Objects.requireNonNull(probeHashChannel, "probeHashChannel is null").orElse(-1);
            this.hasFilter = hasFilter;
        }

        public JoinProbe createJoinProbe(Page page, LookupSource lookupSource) {
            Page probePage = page.getLoadedPage(this.probeJoinChannels);
            return new JoinProbe(this.probeOutputChannels, page, probePage, lookupSource, this.probeHashChannel >= 0 ? page.getBlock(this.probeHashChannel).getLoadedBlock() : null, this.hasFilter);
        }
    }
}

