/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Objects;

public class UnnestingPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UnnestingPositionsAppender.class);
    private final PositionsAppender delegate;
    private DictionaryBlockBuilder dictionaryBlockBuilder;

    public UnnestingPositionsAppender(PositionsAppender delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.dictionaryBlockBuilder = new DictionaryBlockBuilder();
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        if (positions.isEmpty()) {
            return;
        }
        if (source instanceof RunLengthEncodedBlock) {
            this.dictionaryBlockBuilder.flushDictionary(this.delegate);
            this.delegate.appendRle(((RunLengthEncodedBlock)source).getValue(), positions.size());
        } else if (source instanceof DictionaryBlock) {
            this.appendDictionary(positions, (DictionaryBlock)source);
        } else {
            this.dictionaryBlockBuilder.flushDictionary(this.delegate);
            this.delegate.append(positions, source);
        }
    }

    @Override
    public void appendRle(Block block, int rlePositionCount) {
        if (rlePositionCount == 0) {
            return;
        }
        this.dictionaryBlockBuilder.flushDictionary(this.delegate);
        this.delegate.appendRle(block, rlePositionCount);
    }

    @Override
    public void append(int position, Block source) {
        this.dictionaryBlockBuilder.flushDictionary(this.delegate);
        if (source instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)source;
            this.delegate.append(0, runLengthEncodedBlock.getValue());
        } else if (source instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)source;
            this.delegate.append(dictionaryBlock.getId(position), dictionaryBlock.getDictionary());
        } else {
            this.delegate.append(position, source);
        }
    }

    @Override
    public Block build() {
        Block result = this.dictionaryBlockBuilder.isEmpty() ? this.delegate.build() : this.dictionaryBlockBuilder.build();
        this.dictionaryBlockBuilder = this.dictionaryBlockBuilder.newBuilderLike();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.delegate.getRetainedSizeInBytes() + this.dictionaryBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.delegate.getSizeInBytes();
    }

    private void appendDictionary(IntArrayList positions, DictionaryBlock source) {
        Block dictionary = source.getDictionary();
        IntArrayList dictionaryPositions = this.getDictionaryPositions(positions, source);
        if (this.dictionaryBlockBuilder.canAppend(dictionary)) {
            this.dictionaryBlockBuilder.append(dictionaryPositions, dictionary);
        } else {
            this.dictionaryBlockBuilder.flushDictionary(this.delegate);
            this.delegate.append(dictionaryPositions, dictionary);
        }
    }

    private IntArrayList getDictionaryPositions(IntArrayList positions, DictionaryBlock block) {
        int[] positionArray = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            positionArray[i] = block.getId(positions.getInt(i));
        }
        return IntArrayList.wrap((int[])positionArray);
    }

    private static class DictionaryBlockBuilder {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryBlockBuilder.class);
        private final int initialEntryCount;
        private Block dictionary;
        private int[] dictionaryIds;
        private int positionCount;
        private boolean closed;

        public DictionaryBlockBuilder() {
            this(1024);
        }

        public DictionaryBlockBuilder(int initialEntryCount) {
            this.initialEntryCount = initialEntryCount;
            this.dictionaryIds = new int[0];
        }

        public boolean isEmpty() {
            return this.positionCount == 0;
        }

        public Block build() {
            return DictionaryBlock.create((int)this.positionCount, (Block)this.dictionary, (int[])this.dictionaryIds);
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + (long)this.dictionaryIds.length * 4L + (this.dictionary != null ? this.dictionary.getRetainedSizeInBytes() : 0L);
        }

        public boolean canAppend(Block dictionary) {
            return !this.closed && (dictionary == this.dictionary || this.dictionary == null);
        }

        public void append(IntArrayList mappedPositions, Block dictionary) {
            Preconditions.checkArgument((boolean)this.canAppend(dictionary));
            this.dictionary = dictionary;
            this.ensureCapacity(this.positionCount + mappedPositions.size());
            System.arraycopy(mappedPositions.elements(), 0, this.dictionaryIds, this.positionCount, mappedPositions.size());
            this.positionCount += mappedPositions.size();
        }

        public void flushDictionary(PositionsAppender delegate) {
            if (this.closed) {
                return;
            }
            if (this.positionCount > 0) {
                Objects.requireNonNull(this.dictionary, () -> "dictionary is null but we have pending dictionaryIds " + this.positionCount);
                delegate.append(IntArrayList.wrap((int[])this.dictionaryIds, (int)this.positionCount), this.dictionary);
            }
            this.closed = true;
            this.dictionaryIds = new int[0];
            this.positionCount = 0;
            this.dictionary = null;
        }

        public DictionaryBlockBuilder newBuilderLike() {
            return new DictionaryBlockBuilder(Math.max(PositionsAppenderUtil.calculateBlockResetSize(this.positionCount), this.initialEntryCount));
        }

        private void ensureCapacity(int capacity) {
            if (this.dictionaryIds.length >= capacity) {
                return;
            }
            int newSize = this.dictionaryIds.length > 0 ? PositionsAppenderUtil.calculateNewArraySize(this.dictionaryIds.length) : this.initialEntryCount;
            newSize = Math.max(newSize, capacity);
            this.dictionaryIds = IntArrays.ensureCapacity((int[])this.dictionaryIds, (int)newSize, (int)this.positionCount);
        }
    }
}

