/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.JsonPathInvocationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.operator.scalar.json.JsonInputConversionError;
import io.trino.operator.scalar.json.JsonOutputConversionError;
import io.trino.operator.scalar.json.ParameterUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class JsonQueryFunction
extends SqlScalarFunction {
    public static final String JSON_QUERY_FUNCTION_NAME = "$json_query";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonQueryFunction.class, "jsonQuery", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE, Long.TYPE, Long.TYPE);
    private static final JsonNode EMPTY_ARRAY_RESULT = new ArrayNode(JsonNodeFactory.instance);
    private static final JsonNode EMPTY_OBJECT_RESULT = new ObjectNode(JsonNodeFactory.instance);
    private final FunctionManager functionManager;
    private final Metadata metadata;
    private final TypeManager typeManager;

    public JsonQueryFunction(FunctionManager functionManager, Metadata metadata, TypeManager typeManager) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(JSON_QUERY_FUNCTION_NAME).typeVariable("T").returnType(new TypeSignature("json2016", new TypeSignatureParameter[0])).argumentTypes((List)ImmutableList.of((Object)new TypeSignature("json2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("JsonPath2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]))).build()).nullable().argumentNullability(new boolean[]{false, false, true, false, false, false}).hidden().description("Extracts a JSON value from a JSON value").build());
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        Type parametersRowType = boundSignature.getArgumentType(2);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.functionManager).bindTo(this.metadata).bindTo(this.typeManager).bindTo(parametersRowType);
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(JsonPathInvocationContext.class, new Class[0]);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle, Optional.of(instanceFactory));
    }

    /*
     * WARNING - void declaration
     */
    @UsedByGeneratedCode
    public static JsonNode jsonQuery(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long wrapperBehavior, long emptyBehavior, long errorBehavior) {
        void var19_24;
        List<Object> pathResult;
        Object[] parameters;
        if (inputExpression.equals((Object)JsonInputErrorNode.JSON_ERROR)) {
            return JsonQueryFunction.handleSpecialCase(errorBehavior, () -> new JsonInputConversionError("malformed input argument to JSON_QUERY function"));
        }
        for (Object object : parameters = ParameterUtil.getParametersArray(parametersRowType, parametersRow)) {
            if (!object.equals((Object)JsonInputErrorNode.JSON_ERROR)) continue;
            return JsonQueryFunction.handleSpecialCase(errorBehavior, () -> new JsonInputConversionError("malformed JSON path parameter to JSON_QUERY function"));
        }
        JsonPathEvaluator evaluator = invocationContext.getEvaluator();
        if (evaluator == null) {
            evaluator = new JsonPathEvaluator(jsonPath, session, metadata, typeManager, functionManager);
            invocationContext.setEvaluator(evaluator);
        }
        try {
            pathResult = evaluator.evaluate(inputExpression, parameters);
        }
        catch (PathEvaluationError e) {
            return JsonQueryFunction.handleSpecialCase(errorBehavior, () -> e);
        }
        if (pathResult.isEmpty()) {
            return JsonQueryFunction.handleSpecialCase(emptyBehavior, () -> new JsonOutputConversionError("JSON path found no items"));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : pathResult) {
            if (item instanceof TypedValue) {
                Optional<JsonNode> jsonNode = SqlJsonLiteralConverter.getJsonNode((TypedValue)item);
                if (jsonNode.isEmpty()) {
                    return JsonQueryFunction.handleSpecialCase(errorBehavior, () -> new JsonOutputConversionError(String.format("JSON path returned a scalar SQL value of type %s that cannot be represented as JSON", ((TypedValue)item).getType())));
                }
                builder.add((Object)jsonNode.get());
                continue;
            }
            builder.add((Object)((JsonNode)item));
        }
        ImmutableList immutableList = builder.build();
        switch (JsonQuery.ArrayWrapperBehavior.values()[(int)wrapperBehavior]) {
            case WITHOUT: {
                break;
            }
            case UNCONDITIONAL: {
                ImmutableList immutableList2 = ImmutableList.of((Object)new ArrayNode(JsonNodeFactory.instance, (List)immutableList));
                break;
            }
            case CONDITIONAL: {
                if (immutableList.size() == 1 && (((JsonNode)immutableList.get(0)).isArray() || ((JsonNode)immutableList.get(0)).isObject())) break;
                ImmutableList immutableList3 = ImmutableList.of((Object)new ArrayNode(JsonNodeFactory.instance, (List)immutableList));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected array wrapper behavior");
            }
        }
        if (var19_24.size() == 1) {
            return (JsonNode)var19_24.get(0);
        }
        return JsonQueryFunction.handleSpecialCase(errorBehavior, () -> new JsonOutputConversionError("JSON path found multiple items"));
    }

    private static JsonNode handleSpecialCase(long behavior, Supplier<TrinoException> error) {
        switch (JsonQuery.EmptyOrErrorBehavior.values()[(int)behavior]) {
            case NULL: {
                return null;
            }
            case ERROR: {
                throw error.get();
            }
            case EMPTY_ARRAY: {
                return EMPTY_ARRAY_RESULT;
            }
            case EMPTY_OBJECT: {
                return EMPTY_OBJECT_RESULT;
            }
        }
        throw new IllegalStateException("unexpected behavior");
    }
}

