/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.sun.management.OperatingSystemMXBean;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.trino.client.NodeVersion;
import io.trino.memory.LocalMemoryManager;
import io.trino.server.NodeStatus;
import io.trino.server.ServerConfig;
import io.trino.server.security.ResourceSecurity;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/status")
public class StatusResource {
    private final NodeInfo nodeInfo;
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final long startTime = System.nanoTime();
    private final int logicalCores;
    private final LocalMemoryManager memoryManager;
    private final MemoryMXBean memoryMXBean;
    private OperatingSystemMXBean operatingSystemMXBean;

    @Inject
    public StatusResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, LocalMemoryManager memoryManager) {
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = nodeInfo.getEnvironment();
        this.coordinator = serverConfig.isCoordinator();
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.logicalCores = Runtime.getRuntime().availableProcessors();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @HEAD
    @Produces(value={"application/json"})
    public Response statusPing() {
        return Response.ok().build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"application/json"})
    public NodeStatus getStatus() {
        return new NodeStatus(this.nodeInfo.getNodeId(), this.version, this.environment, this.coordinator, Duration.nanosSince((long)this.startTime), this.nodeInfo.getExternalAddress(), this.nodeInfo.getInternalAddress(), this.memoryManager.getInfo(), this.logicalCores, this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getProcessCpuLoad(), this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getSystemCpuLoad(), this.memoryMXBean.getHeapMemoryUsage().getUsed(), this.memoryMXBean.getHeapMemoryUsage().getMax(), this.memoryMXBean.getNonHeapMemoryUsage().getUsed());
    }
}

