/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.RuleStats;
import io.trino.sql.planner.optimizations.OptimizerStats;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExport;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

public class OptimizerStatsMBeanExporter {
    @GuardedBy(value="this")
    private final List<MBeanExport> mbeanExports = new ArrayList<MBeanExport>();
    private final MBeanExporter exporter;
    private final Map<Class<?>, OptimizerStats> optimizerStats;
    private final Map<Class<?>, RuleStats> ruleStats;

    @Inject
    public OptimizerStatsMBeanExporter(MBeanExporter exporter, PlanOptimizersFactory optimizers) {
        Objects.requireNonNull(optimizers, "optimizers is null");
        this.optimizerStats = optimizers.getOptimizerStats();
        this.ruleStats = optimizers.getRuleStats();
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
    }

    @PostConstruct
    public synchronized void export() {
        Preconditions.checkState((boolean)this.mbeanExports.isEmpty(), (Object)"MBeans already exported");
        for (Map.Entry<Class<?>, OptimizerStats> entry : this.optimizerStats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            try {
                this.mbeanExports.add(this.exporter.exportWithGeneratedName((Object)entry.getValue(), PlanOptimizer.class, (Map)ImmutableMap.builder().put((Object)"name", (Object)PlanOptimizer.class.getSimpleName()).put((Object)"optimizer", (Object)entry.getKey().getSimpleName()).buildOrThrow()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with name '%s'", this.getName(entry.getKey())), e);
            }
        }
        for (Map.Entry<Class<?>, Object> entry : this.ruleStats.entrySet()) {
            Verify.verify((!entry.getKey().getSimpleName().isEmpty() ? 1 : 0) != 0);
            try {
                this.mbeanExports.add(this.exporter.exportWithGeneratedName(entry.getValue(), IterativeOptimizer.class, (Map)ImmutableMap.builder().put((Object)"name", (Object)IterativeOptimizer.class.getSimpleName()).put((Object)"rule", (Object)entry.getKey().getSimpleName()).buildOrThrow()));
            }
            catch (RuntimeException e) {
                throw new RuntimeException(String.format("Failed to export MBean with for rule '%s'", entry.getKey().getSimpleName()), e);
            }
        }
    }

    @PreDestroy
    public synchronized void unexport() {
        for (MBeanExport mbeanExport : this.mbeanExports) {
            mbeanExport.unexport();
        }
        this.mbeanExports.clear();
    }

    private String getName(Class<?> key) {
        return ObjectNames.builder(PlanOptimizer.class).withProperty("optimizer", key.getSimpleName()).build();
    }
}

