/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.ParameterKind;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeParameter;
import java.util.List;

public final class ArrayParametricType
implements ParametricType {
    public static final ArrayParametricType ARRAY = new ArrayParametricType();

    private ArrayParametricType() {
    }

    public String getName() {
        return "array";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Array type expects exactly one type as a parameter, got %s", parameters);
        Preconditions.checkArgument((parameters.get(0).getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Array expects type as a parameter, got %s", parameters);
        return new ArrayType(parameters.get(0).getType());
    }
}

