/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.RenameColumnTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.QueryUtil;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.RenameColumn;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestRenameColumnTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testRenameColumn() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a_renamed", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testRenameColumnNotExistingTable() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testRenameColumnNotExistingTableIfExists() {
        QualifiedName tableName = TestRenameColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeRenameColumn(tableName, QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"a_renamed"), true, false));
    }

    @Test
    public void testRenameMissingColumn() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QueryUtil.identifier((String)"missing_column"), QueryUtil.identifier((String)"test"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column 'missing_column' does not exist");
    }

    @Test
    public void testRenameColumnIfExists() {
        QualifiedObjectName tableName = TestRenameColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestRenameColumnTask.simpleTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(tableName), QueryUtil.identifier((String)"missing_column"), QueryUtil.identifier((String)"test"), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("a", (Type)BigintType.BIGINT), new ColumnMetadata("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testRenameColumnOnView() {
        QualifiedObjectName viewName = TestRenameColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestRenameColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(viewName), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testRenameColumnOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestRenameColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeRenameColumn(TestRenameColumnTask.asQualifiedName(materializedViewName), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"a_renamed"), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeRenameColumn(QualifiedName table, Identifier source, Identifier target, boolean tableExists, boolean columnExists) {
        return new RenameColumnTask(this.plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).execute(new RenameColumn(new NodeLocation(1, 1), table, source, target, tableExists, columnExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ConnectorTableMetadata simpleTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT)));
    }
}

