/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.BufferTestUtils;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.OutputBufferStateMachine;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PartitionedOutputBuffer;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPartitionedOutputBuffer {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final ImmutableList<BigintType> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final PipelinedOutputBuffers.OutputBufferId FIRST = new PipelinedOutputBuffers.OutputBufferId(0);
    private static final PipelinedOutputBuffers.OutputBufferId SECOND = new PipelinedOutputBuffers.OutputBufferId(1);
    private static final PipelinedOutputBuffers.OutputBufferId THIRD = new PipelinedOutputBuffers.OutputBufferId(2);
    private ScheduledExecutorService stateNotificationExecutor;

    @BeforeClass
    public void setUp() {
        this.stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.stateNotificationExecutor != null) {
            this.stateNotificationExecutor.shutdownNow();
            this.stateNotificationExecutor = null;
        }
    }

    @Test
    public void testInvalidConstructorArg() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferedBytes must be > 0");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected a final output buffer descriptor");
    }

    @Test
    public void testSimplePartitioned() {
        int i;
        int firstPartition = 0;
        int secondPartition = 1;
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, firstPartition).withBuffer(SECOND, secondPartition).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(20));
        for (i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), firstPartition);
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), secondPartition);
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 3, 0);
        for (i = 3; i < 13; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), firstPartition);
        }
        for (i = 3; i < 10; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), secondPartition);
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 10, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 10, 0);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(13), firstPartition);
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 11, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 10, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), new Page[0]));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 11, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 10, 0);
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 10, 0);
        buffer.get(SECOND, 10L, BufferTestUtils.sizeOfPages(3)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 10);
        BufferTestUtils.assertFutureIsDone(future);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 11, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 10);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(14), firstPartition);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(15), firstPartition);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 13, 3);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 4L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(4L, BufferTestUtils.createPage(4), new Page[0]));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 12, 4);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 12, 4);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 10);
        buffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, SECOND, 10);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 5L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(5L, BufferTestUtils.createPage(5), new Page[0]));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 11, 5);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferResult x = BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(30), BufferTestUtils.NO_WAIT);
        BufferTestUtils.assertBufferResultEquals(TYPES, x, TestPartitionedOutputBuffer.bufferResult(6L, BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9), BufferTestUtils.createPage(10), BufferTestUtils.createPage(11), BufferTestUtils.createPage(12), BufferTestUtils.createPage(13), BufferTestUtils.createPage(14), BufferTestUtils.createPage(15)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 10, 6);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 16L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)16L, (boolean)true));
        buffer.destroy(FIRST);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 16);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
    }

    @Test
    public void testAcknowledge() {
        int partitionId = 0;
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, partitionId).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(20));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), partitionId);
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 2L);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 1, 2);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 3L);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
        try {
            BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 4L);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid sequence id");
        }
        for (int i = 3; i < 6; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), partitionId);
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 3);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 3);
    }

    @Test
    public void testDuplicateRequests() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 3);
    }

    @Test
    public void testAddQueueAfterCreation() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers((OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterFinish() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testAddAfterDestroy() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.destroy();
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testFullBufferBlocksWriter() {
        int firstPartition = 0;
        int secondPartition = 1;
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, firstPartition).withBuffer(SECOND, secondPartition).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1), firstPartition);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2), secondPartition);
        BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3), secondPartition);
    }

    @Test
    public void testAcknowledgementFreesWriters() {
        int firstPartition = 0;
        int secondPartition = 1;
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, firstPartition).withBuffer(SECOND, secondPartition).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1), firstPartition);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2), firstPartition);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 2, 0);
        ListenableFuture<Void> future = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3), secondPartition);
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 2, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 1, 0);
        buffer.get(FIRST, 2L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertFutureIsDone(future);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 1, 0);
    }

    @Test
    public void testAbort() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withBuffer(SECOND, 1).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), 0);
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), 1);
        }
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.destroy(FIRST);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, SECOND, 0);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, SECOND, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFinishClosesEmptyQueues() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withBuffer(SECOND, 1).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 0);
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, SECOND, 0, 0);
        buffer.destroy(FIRST);
        buffer.destroy(SECOND);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 0);
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, SECOND, 0);
    }

    @Test
    public void testAbortFreesReader() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy(FIRST);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 1);
    }

    @Test
    public void testFinishFreesReader() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.setNoMorePages();
        BufferTestUtils.assertQueueState((OutputBuffer)buffer, FIRST, 0, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)true));
    }

    @Test
    public void testFinishFreesWriter() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.setNoMorePages();
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6)));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 7L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)7L, (boolean)true));
        buffer.destroy(FIRST);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
    }

    @Test
    public void testDestroyFreesReader() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy();
        BufferTestUtils.assertQueueClosed((OutputBuffer)buffer, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testDestroyFreesWriter() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.destroy();
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testFailDoesNotFreeReader() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.abort();
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testFailFreesWriter() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = BufferTestUtils.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestPartitionedOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.abort();
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.ABORTED);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testBufferCompletion() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < 5; ++i) {
            Page page = BufferTestUtils.createPage(i);
            BufferTestUtils.addPage((OutputBuffer)buffer, page);
            pages.add(page);
        }
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(5), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FLUSHING);
        buffer.destroy(FIRST);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
    }

    @Test
    public void testBufferFinishesWhenClientBuffersDestroyed() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withBuffer(SECOND, 1).withBuffer(THIRD, 2).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        for (int i = 0; i < 3; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i), i);
        }
        buffer.destroy(FIRST);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.destroy(SECOND);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.NO_MORE_BUFFERS);
        buffer.destroy(THIRD);
        Assert.assertEquals((Object)buffer.getState(), (Object)BufferState.FINISHED);
    }

    @Test
    public void testBufferPeakMemoryUsage() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Page page = BufferTestUtils.createPage(1);
        long serializePageSize = BufferTestUtils.serializePage(page).getRetainedSize();
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, page, 0);
            Assert.assertEquals((long)buffer.getPeakMemoryUsage(), (long)((long)(i + 1) * serializePageSize));
        }
    }

    @Test
    public void testForceFreeMemory() {
        PartitionedOutputBuffer buffer = this.createPartitionedBuffer(PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 5; ++i) {
            BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1), 0);
        }
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        Assert.assertTrue((memoryManager.getBufferedBytes() > 0L ? 1 : 0) != 0);
        buffer.forceFreeMemory();
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
        BufferTestUtils.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
    }

    private PartitionedOutputBuffer createPartitionedBuffer(PipelinedOutputBuffers buffers, DataSize dataSize) {
        return new PartitionedOutputBuffer(TASK_INSTANCE_ID, new OutputBufferStateMachine(new TaskId(new StageId(new QueryId("query"), 0), 0, 0), (Executor)this.stateNotificationExecutor), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)this.stateNotificationExecutor);
    }

    private static BufferResult bufferResult(long token, Page firstPage, Page ... otherPages) {
        ImmutableList pages = ImmutableList.builder().add((Object)firstPage).add((Object[])otherPages).build();
        return BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, token, (List<Page>)pages);
    }
}

