/*
 * Decompiled with CFR 0.152.
 */
package io.trino.likematcher;

import com.google.common.base.Strings;
import io.trino.likematcher.LikeMatcher;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLikeMatcher {
    @Test
    public void test() {
        Assertions.assertFalse((boolean)TestLikeMatcher.match("__", "a"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("__", "abcdefghi"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("a%", "xyz"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("a%", "a"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("a%", "ab"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("a_", "ab"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%a", "xyz"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%z", "z"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%z", "yz"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_z", "yz"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("abcd", "abcd"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("_", ""));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_", "a"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("_", "ab"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%", ""));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%", "a"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%", "ab"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_%", "abcdefg"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("_a%", "abcdefg"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_ab_", "xabc"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("_ab_", "xyxw"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_a%b_", "xaxxxbx"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("_%_%_%_%", "abcdefghij"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%a%a%a%a%a%a%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%a%a%a%a%a%a%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%a%b%a%b%a%b%", "aabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabbaabb"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%aaaa%bbbb%aaaa%bbbb%aaaa%bbbb%", "aaaabbbbaaaabbbbaaaabbbb"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%aaaaaaaaaaaaaaaaaaaaaaaaaa%", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%aab%bba%aab%bba%", "aaaabbbbaaaabbbbaaaa"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%aab%bba%aab%bba%", "aaaabbbbaaaabbbbcccc"));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%abaca%", "abababababacabababa"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%bcccccccca%", "bbbbbbbbxax"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%bbxxxxxa%", "bbbxxxxaz"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%aaaaaaxaaaaaa%", Strings.repeat((String)"a", (int)20) + Strings.repeat((String)"b", (int)20) + Strings.repeat((String)"a", (int)20) + Strings.repeat((String)"b", (int)20) + "the quick brown fox jumps over the lazy dog"));
        Assertions.assertFalse((boolean)TestLikeMatcher.match("%abaaa%", "ababaa"));
        LikeMatcher singleOptimized = LikeMatcher.compile((String)"_", Optional.empty(), (boolean)true);
        LikeMatcher multipleOptimized = LikeMatcher.compile((String)"_a%b_", Optional.empty(), (boolean)true);
        LikeMatcher single = LikeMatcher.compile((String)"_", Optional.empty(), (boolean)false);
        LikeMatcher multiple = LikeMatcher.compile((String)"_a%b_", Optional.empty(), (boolean)false);
        for (int i = 0; i < 0x10FFFF; ++i) {
            Assertions.assertTrue((boolean)singleOptimized.match(Character.toString(i).getBytes(StandardCharsets.UTF_8)));
            Assertions.assertTrue((boolean)single.match(Character.toString(i).getBytes(StandardCharsets.UTF_8)));
            String value = "aa" + (char)i + "bb";
            Assertions.assertTrue((boolean)multipleOptimized.match(value.getBytes(StandardCharsets.UTF_8)));
            Assertions.assertTrue((boolean)multiple.match(value.getBytes(StandardCharsets.UTF_8)));
        }
    }

    @Test
    public void testEscape() {
        Assertions.assertTrue((boolean)TestLikeMatcher.match("-%", "%", '-'));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("-_", "_", '-'));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("--", "-", '-'));
        Assertions.assertTrue((boolean)TestLikeMatcher.match("%$_%", "xxxxx_xxxxx", '$'));
    }

    private static boolean match(String pattern, String value) {
        return TestLikeMatcher.match(pattern, value, Optional.empty());
    }

    private static boolean match(String pattern, String value, char escape) {
        return TestLikeMatcher.match(pattern, value, Optional.of(Character.valueOf(escape)));
    }

    private static boolean match(String pattern, String value, Optional<Character> escape) {
        String padding = "++++";
        String padded = padding + value + padding;
        byte[] bytes = padded.getBytes(StandardCharsets.UTF_8);
        boolean optimizedWithoutPadding = LikeMatcher.compile((String)pattern, escape, (boolean)true).match(value.getBytes(StandardCharsets.UTF_8));
        boolean optimizedWithPadding = LikeMatcher.compile((String)pattern, escape, (boolean)true).match(bytes, padding.length(), bytes.length - padding.length() * 2);
        Assertions.assertEquals((Object)optimizedWithoutPadding, (Object)optimizedWithPadding);
        boolean withoutPadding = LikeMatcher.compile((String)pattern, escape, (boolean)false).match(value.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)optimizedWithoutPadding, (Object)withoutPadding);
        boolean withPadding = LikeMatcher.compile((String)pattern, escape, (boolean)false).match(bytes, padding.length(), bytes.length - padding.length() * 2);
        Assertions.assertEquals((Object)optimizedWithoutPadding, (Object)withPadding);
        return withPadding;
    }
}

