/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.Lists;
import io.trino.array.LongBigArray;
import io.trino.operator.GroupedTopNRankAccumulator;
import io.trino.operator.RowIdComparisonHashStrategy;
import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNRankAccumulator {
    private static final RowIdComparisonHashStrategy STRATEGY = new RowIdComparisonHashStrategy(){

        public int compare(long leftRowId, long rightRowId) {
            return Long.compare(leftRowId, rightRowId);
        }

        public long hashCode(long rowId) {
            return rowId;
        }
    };

    @DataProvider
    public static Object[][] parameters() {
        List<Integer> topNs = Arrays.asList(1, 2, 3);
        List<Integer> valueCounts = Arrays.asList(0, 1, 2, 4, 8);
        List<Integer> groupCounts = Arrays.asList(1, 2, 3);
        List<Boolean> drainWithRankings = Arrays.asList(true, false);
        return TestGroupedTopNRankAccumulator.to2DArray(Lists.cartesianProduct((List[])new List[]{topNs, valueCounts, groupCounts, drainWithRankings}));
    }

    private static Object[][] to2DArray(List<List<Object>> nestedList) {
        Object[][] array = new Object[nestedList.size()][];
        for (int i = 0; i < nestedList.size(); ++i) {
            array[i] = nestedList.get(i).toArray();
        }
        return array;
    }

    @Test(dataProvider="parameters")
    public void testSinglePeerGroupInsert(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        int rowId = -1;
        int i = 0;
        while ((long)i < valueCount) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assert.assertTrue((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId)));
                accumulator.verifyIntegrity();
                Assert.assertTrue((boolean)evicted.isEmpty());
                ++groupId;
            }
            ++i;
        }
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            if (drainWithRanking) {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput), (long)valueCount);
            } else {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput), (long)valueCount);
            }
            accumulator.verifyIntegrity();
            int i2 = 0;
            while ((long)i2 < valueCount) {
                Assert.assertEquals((long)rowIdOutput.get((long)i2), (long)rowId);
                if (drainWithRanking) {
                    Assert.assertEquals((long)rankingOutput.get((long)i2), (long)1L);
                }
                ++i2;
            }
            ++groupId;
        }
    }

    @Test(dataProvider="parameters")
    public void testIncreasingAllUniqueValues(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        int rowId = 0;
        while ((long)rowId < valueCount) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assert.assertEquals((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId)), (rowId < topN ? 1 : 0) != 0);
                accumulator.verifyIntegrity();
                Assert.assertTrue((boolean)evicted.isEmpty());
                ++groupId;
            }
            ++rowId;
        }
        long expectedResultCount = Math.min(valueCount, (long)topN);
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            if (drainWithRanking) {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput), (long)expectedResultCount);
            } else {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput), (long)expectedResultCount);
            }
            accumulator.verifyIntegrity();
            int rowId2 = 0;
            while ((long)rowId2 < expectedResultCount) {
                Assert.assertEquals((long)rowIdOutput.get((long)rowId2), (long)rowId2);
                if (drainWithRanking) {
                    Assert.assertEquals((long)rankingOutput.get((long)rowId2), (long)(rowId2 + 1));
                }
                ++rowId2;
            }
            ++groupId;
        }
    }

    @Test(dataProvider="parameters")
    public void testDecreasingAllUniqueValues(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        ArrayList<Long> expectedEvicted = new ArrayList<Long>();
        for (long rowId = valueCount - 1L; rowId >= 0L; --rowId) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assert.assertTrue((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId)));
                accumulator.verifyIntegrity();
                if (rowId >= (long)topN) {
                    expectedEvicted.add(rowId);
                }
                ++groupId;
            }
        }
        Assert.assertEquals((Collection)evicted, expectedEvicted);
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            long expectedResultCount = Math.min(valueCount, (long)topN);
            if (drainWithRanking) {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput), (long)expectedResultCount);
            } else {
                Assert.assertEquals((long)accumulator.drainTo(groupId, rowIdOutput), (long)expectedResultCount);
            }
            accumulator.verifyIntegrity();
            int rowId = 0;
            while ((long)rowId < expectedResultCount) {
                Assert.assertEquals((long)rowIdOutput.get((long)rowId), (long)rowId);
                if (drainWithRanking) {
                    Assert.assertEquals((long)rankingOutput.get((long)rowId), (long)(rowId + 1));
                }
                ++rowId;
            }
            ++groupId;
        }
    }

    @Test
    public void testMultipleDuplicateValues() {
        int topN = 3;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L)));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)evicted.isEmpty());
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(1L)));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)evicted.isEmpty());
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L)));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)evicted.isEmpty());
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(1L)));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)evicted.isEmpty());
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L)));
        accumulator.verifyIntegrity();
        Assert.assertEquals((Collection)evicted, Arrays.asList(1L, 1L));
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(-1L)));
        accumulator.verifyIntegrity();
        Assert.assertEquals((Collection)evicted, Arrays.asList(1L, 1L));
        Assert.assertTrue((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(-1L)));
        accumulator.verifyIntegrity();
        Assert.assertEquals((Collection)evicted, Arrays.asList(1L, 1L));
        LongBigArray rowIdOutput = new LongBigArray();
        LongBigArray rankingOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0, rowIdOutput, rankingOutput), (long)5L);
        Assert.assertEquals((long)rowIdOutput.get(0L), (long)-1L);
        Assert.assertEquals((long)rankingOutput.get(0L), (long)1L);
        Assert.assertEquals((long)rowIdOutput.get(1L), (long)-1L);
        Assert.assertEquals((long)rankingOutput.get(1L), (long)1L);
        Assert.assertEquals((long)rowIdOutput.get(2L), (long)0L);
        Assert.assertEquals((long)rankingOutput.get(2L), (long)3L);
        Assert.assertEquals((long)rowIdOutput.get(3L), (long)0L);
        Assert.assertEquals((long)rankingOutput.get(3L), (long)3L);
        Assert.assertEquals((long)rowIdOutput.get(4L), (long)0L);
        Assert.assertEquals((long)rankingOutput.get(4L), (long)3L);
    }

    private static RowReference toRowReference(final long rowId) {
        return new RowReference(){

            public int compareTo(RowIdComparisonStrategy strategy, long otherRowId) {
                return strategy.compare(rowId, otherRowId);
            }

            public boolean equals(RowIdHashStrategy strategy, long otherRowId) {
                return strategy.equals(rowId, otherRowId);
            }

            public long hash(RowIdHashStrategy strategy) {
                return strategy.hashCode(rowId);
            }

            public long allocateRowId() {
                return rowId;
            }
        };
    }
}

