/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.operator.PipelineStats;
import io.trino.operator.TaskStats;
import io.trino.operator.TestPipelineStats;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTaskStats {
    public static final TaskStats EXPECTED = new TaskStats(new DateTime(1L), new DateTime(2L), new DateTime(100L), new DateTime(102L), new DateTime(101L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 6, 7, 5, 28L, 8, 6, 29L, 24, 10, 11.0, DataSize.ofBytes((long)12L), DataSize.ofBytes((long)120L), DataSize.ofBytes((long)13L), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)191L), 201L, new Duration(15.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)192L), 202L, DataSize.ofBytes((long)19L), 20L, DataSize.ofBytes((long)21L), 22L, new Duration(271.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)23L), 24L, new Duration(272.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)25L), Optional.of(2), 26, new Duration(27.0, TimeUnit.NANOSECONDS), (List)ImmutableList.of((Object)TestPipelineStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TaskStats.class);
        String json = codec.toJson((Object)EXPECTED);
        TaskStats actual = (TaskStats)codec.fromJson(json);
        TestTaskStats.assertExpectedTaskStats(actual);
    }

    public static void assertExpectedTaskStats(TaskStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getTerminatingStartTime(), (Object)new DateTime(102L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastEndTime(), (Object)new DateTime(101L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)6);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)5);
        Assert.assertEquals((long)actual.getQueuedPartitionedSplitsWeight(), (long)28L);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)6);
        Assert.assertEquals((long)actual.getRunningPartitionedSplitsWeight(), (long)29L);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)24);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)10);
        Assert.assertEquals((Object)actual.getCumulativeUserMemory(), (Object)11.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)12L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)120L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)13L));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)191L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)201L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)192L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)202L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)19L));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)20L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)DataSize.ofBytes((long)21L));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)22L);
        Assert.assertEquals((Object)actual.getInputBlockedTime(), (Object)new Duration(271.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)23L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)24L);
        Assert.assertEquals((Object)actual.getOutputBlockedTime(), (Object)new Duration(272.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)25L));
        Assert.assertEquals((int)actual.getPipelines().size(), (int)1);
        TestPipelineStats.assertExpectedPipelineStats((PipelineStats)actual.getPipelines().get(0));
    }
}

