/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.tree.QualifiedName;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealHistogramAggregation {
    private final TestingAggregationFunction function = new TestingFunctionResolution().getAggregateFunction(QualifiedName.of((String)"numeric_histogram"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE}));
    private final Page input = TestRealHistogramAggregation.makeInput(10);

    @Test
    public void test() {
        Aggregator singleStep = this.createAggregator(AggregationNode.Step.SINGLE);
        singleStep.processPage(this.input);
        Block expected = AggregationTestUtils.getFinalBlock(this.function.getFinalType(), singleStep);
        Aggregator partialStep = this.createAggregator(AggregationNode.Step.PARTIAL);
        partialStep.processPage(this.input);
        Block partialBlock = AggregationTestUtils.getIntermediateBlock(this.function.getIntermediateType(), partialStep);
        Aggregator finalStep = this.createAggregator(AggregationNode.Step.FINAL);
        finalStep.processPage(new Page(new Block[]{partialBlock}));
        Block actual = AggregationTestUtils.getFinalBlock(this.function.getFinalType(), finalStep);
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), TestRealHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() {
        Aggregator singleStep = this.createAggregator(AggregationNode.Step.SINGLE);
        singleStep.processPage(this.input);
        Block singleStepResult = AggregationTestUtils.getFinalBlock(this.function.getFinalType(), singleStep);
        Aggregator partialStep = this.createAggregator(AggregationNode.Step.PARTIAL);
        partialStep.processPage(this.input);
        Block intermediate = AggregationTestUtils.getIntermediateBlock(this.function.getIntermediateType(), partialStep);
        Aggregator finalStep = this.createAggregator(AggregationNode.Step.FINAL);
        finalStep.processPage(new Page(new Block[]{intermediate}));
        finalStep.processPage(new Page(new Block[]{intermediate}));
        Block actual = AggregationTestUtils.getFinalBlock(this.function.getFinalType(), finalStep);
        Map expected = Maps.transformValues(TestRealHistogramAggregation.extractSingleValue(singleStepResult), value -> Float.valueOf(value.floatValue() * 2.0f));
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    private Aggregator createAggregator(AggregationNode.Step step) {
        return this.function.createAggregatorFactory(step, (List<Integer>)(step.isInputRaw() ? ImmutableList.of((Object)0, (Object)1, (Object)2) : ImmutableList.of((Object)0)), OptionalInt.empty()).createAggregator();
    }

    @Test
    public void testNull() {
        Aggregator aggregator = this.createAggregator(AggregationNode.Step.SINGLE);
        Block result = AggregationTestUtils.getFinalBlock(this.function.getFinalType(), aggregator);
        Assert.assertEquals((int)result.getPositionCount(), (int)1);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    @Test
    public void testBadNumberOfBuckets() {
        Aggregator singleStep = this.createAggregator(AggregationNode.Step.SINGLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> singleStep.processPage(TestRealHistogramAggregation.makeInput(0))).isInstanceOf(TrinoException.class)).hasMessage("numeric_histogram bucket count must be greater than one");
        AggregationTestUtils.getFinalBlock(this.function.getFinalType(), singleStep);
    }

    private static Map<Float, Float> extractSingleValue(Block block) {
        MapType mapType = StructuralTestUtil.mapType((Type)RealType.REAL, (Type)RealType.REAL);
        return (Map)mapType.getObjectValue(null, block, 0);
    }

    private static Page makeInput(int numberOfBuckets) {
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            builder.declarePosition();
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            RealType.REAL.writeLong(builder.getBlockBuilder(1), (long)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        return builder.build();
    }
}

