/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.histogram.SingleTypedHistogram;
import io.trino.operator.aggregation.histogram.TypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import io.trino.util.StructuralTestUtil;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedHistogram {
    private static final BlockTypeOperators BLOCK_TYPE_OPERATORS = new BlockTypeOperators(new TypeOperators());

    @Test
    public void testMassive() {
        BlockBuilder inputBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 5000);
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, BLOCK_TYPE_OPERATORS.getEqualOperator((Type)BigintType.BIGINT), BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)BigintType.BIGINT), 1000);
        IntStream.range(1, 2000).flatMap(i -> IntStream.iterate(i, IntUnaryOperator.identity()).limit(i)).forEach(j -> BigintType.BIGINT.writeLong(inputBlockBuilder, (long)j));
        Block inputBlock = inputBlockBuilder.build();
        this.addInputBlockToTypedHistogram((TypedHistogram)typedHistogram, inputBlock);
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        BlockBuilder out = mapType.createBlockBuilder(null, 1);
        typedHistogram.serialize(out);
        Block outputBlock = mapType.getObject((Block)out, 0);
        for (int i2 = 0; i2 < outputBlock.getPositionCount(); i2 += 2) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(outputBlock, i2 + 1), (long)BigintType.BIGINT.getLong(outputBlock, i2));
        }
    }

    @Test
    public void testGetPositionCountBasic() {
        Block inputBlock = BlockAssertions.createLongsBlock(1, 2, 3);
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, BLOCK_TYPE_OPERATORS.getEqualOperator((Type)BigintType.BIGINT), BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)BigintType.BIGINT), inputBlock.getPositionCount());
        this.addInputBlockToTypedHistogram((TypedHistogram)typedHistogram, inputBlock);
        Assert.assertEquals((int)typedHistogram.getPositionCount(), (int)3);
    }

    @Test
    public void testGetPositionCountDuplicates() {
        Block inputBlock = BlockAssertions.createLongsBlock(1, 2, 1);
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, BLOCK_TYPE_OPERATORS.getEqualOperator((Type)BigintType.BIGINT), BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)BigintType.BIGINT), inputBlock.getPositionCount());
        this.addInputBlockToTypedHistogram((TypedHistogram)typedHistogram, inputBlock);
        Assert.assertEquals((int)typedHistogram.getPositionCount(), (int)2);
    }

    @Test
    public void testGetPositionCountLargeExpected() {
        Block inputBlock = BlockAssertions.createLongsBlock(1, 2, 3);
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, BLOCK_TYPE_OPERATORS.getEqualOperator((Type)BigintType.BIGINT), BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)BigintType.BIGINT), 99);
        this.addInputBlockToTypedHistogram((TypedHistogram)typedHistogram, inputBlock);
        Assert.assertEquals((int)typedHistogram.getPositionCount(), (int)3);
    }

    @Test
    public void testGetPositionCountEmpty() {
        Block inputBlock = BigintType.BIGINT.createBlockBuilder(null, 0).build();
        SingleTypedHistogram typedHistogram = new SingleTypedHistogram((Type)BigintType.BIGINT, BLOCK_TYPE_OPERATORS.getEqualOperator((Type)BigintType.BIGINT), BLOCK_TYPE_OPERATORS.getHashCodeOperator((Type)BigintType.BIGINT), 1);
        this.addInputBlockToTypedHistogram((TypedHistogram)typedHistogram, inputBlock);
        Assert.assertEquals((int)typedHistogram.getPositionCount(), (int)0);
    }

    private void addInputBlockToTypedHistogram(TypedHistogram typedHistogram, Block inputBlock) {
        for (int i = 0; i < inputBlock.getPositionCount(); ++i) {
            typedHistogram.add(i, inputBlock, 1L);
        }
    }
}

