/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.operator.exchange.UniformPartitionRebalancer;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestUniformPartitionRebalancer {
    @Test
    public void testRebalanceWithWriterSkewness() {
        AtomicLong physicalWrittenBytesForWriter0 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter1 = new AtomicLong(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 4, 2, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 2), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)20000L)));
        physicalWrittenBytesForWriter1.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)0)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 3), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)40000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)0)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 1), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 3), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)20000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)0), ImmutableList.of((Object)1, (Object)0)});
    }

    @Test
    public void testComputeRebalanceThroughputWithAllWritersOfTheSamePartition() {
        AtomicLong physicalWrittenBytesForWriter0 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter1 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter2 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter3 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter4 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter5 = new AtomicLong(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get, physicalWrittenBytesForWriter2::get, physicalWrittenBytesForWriter3::get, physicalWrittenBytesForWriter4::get, physicalWrittenBytesForWriter5::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 2, 6, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 2)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)100L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 2)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2), ImmutableList.of((Object)1)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)200L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 0), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter2.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 2)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2, (Object)3), ImmutableList.of((Object)1)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)30000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)300L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 0), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(3, 0), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter2.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter3.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 2)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2, (Object)3, (Object)4), ImmutableList.of((Object)1)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)40000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)9300L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 0), (Object)30000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(3, 0), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(4, 0), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)400L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)93L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter2.set(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter3.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter4.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 2)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)2, (Object)3, (Object)4, (Object)5), ImmutableList.of((Object)1)});
    }

    @Test
    public void testRebalanceAffectAllWritersOfTheSamePartition() {
        AtomicLong physicalWrittenBytesForWriter0 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter1 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter2 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter3 = new AtomicLong(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get, physicalWrittenBytesForWriter2::get, physicalWrittenBytesForWriter3::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 3, 4, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 3)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 3)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1), ImmutableList.of((Object)2)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 3)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)2)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)13000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 1), (Object)3000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 0), (Object)1000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)11000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 2), (Object)1000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)141L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)140L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter2.set(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 3)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)1, (Object)3), ImmutableList.of((Object)1, (Object)0), ImmutableList.of((Object)2)});
    }

    @Test
    public void testNoRebalanceWhenDataWrittenIsLessThanTheRebalanceLimit() {
        AtomicLong physicalWrittenBytesForWriter0 = new AtomicLong(0L);
        AtomicLong physicalWrittenBytesForWriter1 = new AtomicLong(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 4, 2, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 2), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)20000L)));
        physicalWrittenBytesForWriter1.set(DataSize.of((long)30L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
    }

    @Test
    public void testNoRebalanceWithoutWriterSkewness() {
        AtomicReference<Long> physicalWrittenBytesForWriter0 = new AtomicReference<Long>(0L);
        AtomicReference<Long> physicalWrittenBytesForWriter1 = new AtomicReference<Long>(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 4, 2, DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 2), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)20000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter1.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
    }

    @Test
    public void testNoRebalanceWhenDataWrittenByThePartitionIsLessThanWriterMinSize() {
        AtomicReference<Long> physicalWrittenBytesForWriter0 = new AtomicReference<Long>(0L);
        AtomicReference<Long> physicalWrittenBytesForWriter1 = new AtomicReference<Long>(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 4, 2, DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)20000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 2), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 3), (Object)20000L)));
        physicalWrittenBytesForWriter1.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 4)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)0), ImmutableList.of((Object)1)});
    }

    @Test
    public void testPartitionShouldNotScaledTwiceInTheSameRebalanceCall() {
        AtomicReference<Long> physicalWrittenBytesForWriter0 = new AtomicReference<Long>(0L);
        AtomicReference<Long> physicalWrittenBytesForWriter1 = new AtomicReference<Long>(0L);
        AtomicReference<Long> physicalWrittenBytesForWriter2 = new AtomicReference<Long>(0L);
        ImmutableList writerPhysicalWrittenBytes = ImmutableList.of(physicalWrittenBytesForWriter0::get, physicalWrittenBytesForWriter1::get, physicalWrittenBytesForWriter2::get);
        AtomicReference<Long2LongOpenHashMap> partitionRowCounts = new AtomicReference<Long2LongOpenHashMap>(new Long2LongOpenHashMap());
        UniformPartitionRebalancer partitionRebalancer = new UniformPartitionRebalancer((List)writerPhysicalWrittenBytes, partitionRowCounts::get, 6, 3, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 0), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 1), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 2), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(0, 3), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(1, 4), (Object)2L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 5), (Object)20000L)));
        physicalWrittenBytesForWriter2.set(DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 6)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2), ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2, (Object)0)});
        partitionRowCounts.set((Long2LongOpenHashMap)this.serializeToLong2LongMap((Map<UniformPartitionRebalancer.WriterPartitionId, Long>)ImmutableMap.of((Object)new UniformPartitionRebalancer.WriterPartitionId(0, 5), (Object)10000L, (Object)new UniformPartitionRebalancer.WriterPartitionId(2, 5), (Object)10000L)));
        physicalWrittenBytesForWriter0.set(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        physicalWrittenBytesForWriter2.set(DataSize.of((long)300L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        partitionRebalancer.rebalancePartitions();
        Assertions.assertThat(this.getWriterIdsForPartitions(partitionRebalancer, 6)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2), ImmutableList.of((Object)0), ImmutableList.of((Object)1), ImmutableList.of((Object)2, (Object)0, (Object)1)});
    }

    private Long2LongMap serializeToLong2LongMap(Map<UniformPartitionRebalancer.WriterPartitionId, Long> input) {
        return new Long2LongOpenHashMap((Map)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> UniformPartitionRebalancer.WriterPartitionId.serialize((UniformPartitionRebalancer.WriterPartitionId)((UniformPartitionRebalancer.WriterPartitionId)entry.getKey())), Map.Entry::getValue)));
    }

    private List<List<Integer>> getWriterIdsForPartitions(UniformPartitionRebalancer partitionRebalancer, int partitionCount) {
        return (List)IntStream.range(0, partitionCount).mapToObj(arg_0 -> ((UniformPartitionRebalancer)partitionRebalancer).getWriterIds(arg_0)).collect(ImmutableList.toImmutableList());
    }
}

