/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.util.MoreMaps;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMapZipWithFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBasic() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> k + v1 + v2)").binding("a", "map(ARRAY [1, 2, 3], ARRAY [10, 20, 30])").binding("b", "map(ARRAY [1, 2, 3], ARRAY [1, 4, 9])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)12, (Object)2, (Object)26, (Object)3, (Object)42));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> v1)").binding("a", "map(ARRAY ['a', 'b'], ARRAY [1, 2])").binding("b", "map(ARRAY ['c', 'd'], ARRAY [30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(MoreMaps.asMap(Arrays.asList("a", "b", "c", "d"), Arrays.asList(1, 2, null, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> v2)").binding("a", "map(ARRAY ['a', 'b'], ARRAY [1, 2])").binding("b", "map(ARRAY ['c', 'd'], ARRAY [30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(MoreMaps.asMap(Arrays.asList("a", "b", "c", "d"), Arrays.asList(null, null, 30, 40)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> (v1, v2))").binding("a", "map(ARRAY ['a', 'b', 'c'], ARRAY [1, 2, 3])").binding("b", "map(ARRAY ['b', 'c', 'd', 'e'], ARRAY ['x', 'y', 'z', null])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createVarcharType((int)1))))).isEqualTo(ImmutableMap.of((Object)"a", Arrays.asList(1, null), (Object)"b", (Object)ImmutableList.of((Object)2, (Object)"x"), (Object)"c", (Object)ImmutableList.of((Object)3, (Object)"y"), (Object)"d", Arrays.asList(null, "z"), (Object)"e", Arrays.asList(null, null)));
    }

    @Test
    public void testTypes() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> v1 * v2 - k)").binding("a", "map(ARRAY [25, 26, 27], ARRAY [25, 26, 27])").binding("b", "map(ARRAY [25, 26, 27], ARRAY [1, 2, 3])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)25, (Object)0, (Object)26, (Object)26, (Object)27, (Object)54));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> v1 + v2 - k)").binding("a", "map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [25, 26, 27])").binding("b", "map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [1, 2, 3])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)1.25, (Object)27.875, (Object)2.125));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> k AND v1 % v2 = 0)").binding("a", "map(ARRAY [true, false], ARRAY [25, 26])").binding("b", "map(ARRAY [true, false], ARRAY [1, 2])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)true, (Object)true, (Object)false, (Object)false));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> k || ':' || CAST(v1/v2 AS VARCHAR))").binding("a", "map(ARRAY ['s0', 's1', 's2'], ARRAY [25, 26, 27])").binding("b", "map(ARRAY ['s0', 's1', 's2'], ARRAY [1, 2, 3])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"s0", (Object)"s0:25", (Object)"s1", (Object)"s1:13", (Object)"s2", (Object)"s2:9"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("map_zip_with(a, b, (k, v1, v2) -> if(v1 % v2 = 0, reverse(k), k))").binding("a", "map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25, 26])").binding("b", "map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [5, 6])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)2, (Object)1), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)3, (Object)4)));
    }
}

