/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestScalarParser {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalar(GenericWithIncompleteSpecializationNullable.class).scalar(GenericWithIncompleteSpecializationNotNullable.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testGenericWithIncompleteSpecialization() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_nullable", "9876543210")))).isEqualTo(9876543210L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_nullable", "1.234E0")))).isEqualTo(1.234);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_nullable", "'abcd'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("abcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_nullable", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_nullable", "array[1, 2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_not_nullable", "9876543210")))).isEqualTo(9876543210L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_not_nullable", "1.234E0")))).isEqualTo(1.234);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_not_nullable", "'abcd'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("abcd");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_not_nullable", "true")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("generic_incomplete_specialization_not_nullable", "array[1, 2]")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
    }

    @ScalarFunction(value="generic_incomplete_specialization_nullable")
    public static final class GenericWithIncompleteSpecializationNullable {
        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Object input) {
            return input;
        }

        @TypeParameter(value="E")
        @SqlNullable
        @SqlType(value="E")
        public static Long specializedSlice(@TypeParameter(value="E") Type type, @SqlNullable @SqlType(value="E") Long input) {
            return input;
        }
    }

    @ScalarFunction(value="generic_incomplete_specialization_not_nullable")
    public static final class GenericWithIncompleteSpecializationNotNullable {
        @TypeParameter(value="E")
        @SqlType(value="E")
        public static Object generic(@TypeParameter(value="E") Type type, @SqlType(value="E") Object input) {
            return input;
        }

        @TypeParameter(value="E")
        @SqlType(value="E")
        public static long specializedSlice(@TypeParameter(value="E") Type type, @SqlType(value="E") long input) {
            return input;
        }
    }
}

