/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.json.JsonCodec;
import io.jsonwebtoken.impl.DefaultClaims;
import io.trino.server.security.oauth2.BaseOAuth2WebUiAuthenticationFilterTest;
import io.trino.server.security.oauth2.TestingHydraIdentityProvider;
import java.io.IOException;
import java.util.Map;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;

public class TestOAuth2WebUiAuthenticationFilterWithOpaque
extends BaseOAuth2WebUiAuthenticationFilterTest {
    @Override
    protected Map<String, String> getOAuth2Config(String idpUrl) {
        return ImmutableMap.builder().put((Object)"web-ui.enabled", (Object)"true").put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.authentication.oauth2.issuer", (Object)"https://localhost:4444/").put((Object)"http-server.authentication.oauth2.auth-url", (Object)(idpUrl + "/oauth2/auth")).put((Object)"http-server.authentication.oauth2.token-url", (Object)(idpUrl + "/oauth2/token")).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)(idpUrl + "/.well-known/jwks.json")).put((Object)"http-server.authentication.oauth2.userinfo-url", (Object)(idpUrl + "/userinfo")).put((Object)"http-server.authentication.oauth2.client-id", (Object)"trino-client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"trino-secret").put((Object)"http-server.authentication.oauth2.principal-field", (Object)"iss").put((Object)"http-server.authentication.oauth2.additional-audiences", (Object)"trusted-client").put((Object)"http-server.authentication.oauth2.max-clock-skew", (Object)"0s").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)(@.*)?").put((Object)"http-server.authentication.oauth2.oidc.discovery", (Object)"false").put((Object)"oauth2-jwk.http-client.trust-store-path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).buildOrThrow();
    }

    @Override
    protected TestingHydraIdentityProvider getHydraIdp() throws Exception {
        TestingHydraIdentityProvider hydraIdP = new TestingHydraIdentityProvider(TTL_ACCESS_TOKEN_IN_SECONDS, false, false);
        hydraIdP.start();
        return hydraIdP;
    }

    @Override
    protected void validateAccessToken(String cookieValue) {
        Request request = new Request.Builder().url("https://localhost:" + this.hydraIdP.getAuthPort() + "/userinfo").addHeader("Authorization", "Bearer " + cookieValue).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            Assertions.assertThat((Object)response.body()).isNotNull();
            DefaultClaims claims = new DefaultClaims((Map)JsonCodec.mapJsonCodec(String.class, Object.class).fromJson(response.body().bytes()));
            Assertions.assertThat((String)claims.getSubject()).isEqualTo("foo@bar.com");
            ((ListAssert)Assertions.assertThat((Object)claims.get((Object)"aud")).asInstanceOf(InstanceOfAssertFactories.list(String.class))).contains((Object[])new String[]{"trino-client"});
        }
        catch (IOException e) {
            Assertions.fail((String)"Exception while calling /userinfo", (Throwable)e);
        }
    }
}

